/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.penalties.attribute;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public class PotionTemplate {
    ResourceLocation resourceLocation;
    int duration;
    int amplifier;
    boolean curable;

    public PotionTemplate(ResourceLocation resourceLocation, int duration, int amplifier, boolean curable) {
        this.resourceLocation = resourceLocation;
        this.duration = duration;
        this.amplifier = amplifier;
        this.curable = curable;
    }

    Potion getPotion() {
        return (Potion)Potion.field_188414_b.func_82594_a((Object)this.resourceLocation);
    }

    public PotionEffect createEffect() {
        Potion potion = this.getPotion();
        PotionEffect potionEffect = new PotionEffect(potion, this.duration, this.amplifier, false, false);
        if (!this.curable) {
            potionEffect.setCurativeItems((List)Lists.newArrayList());
        }
        return potionEffect;
    }

    public String serialize() {
        return String.format("%s/%s/%s/%s", this.resourceLocation.toString(), this.duration, this.amplifier, this.curable);
    }

    public static PotionTemplate deserialize(String string) {
        String[] splitString = string.split("/");
        return new PotionTemplate(new ResourceLocation(splitString[0]), Integer.parseInt(splitString[1]), Integer.parseInt(splitString[2]), Boolean.parseBoolean(splitString[3]));
    }
}

