/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.orientations;

import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import betterwithmods.module.gameplay.miniblocks.orientations.OrientationUtils;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum MouldingOrientation implements BaseOrientation
{
    NORTH_UP("north_up", 180, 270, new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5)),
    SOUTH_UP("south_up", 180, 0, new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0)),
    WEST_UP("west_up", 180, 180, new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0)),
    EAST_UP("east_up", 180, 90, new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0)),
    NORTH_DOWN("north_down", 0, 270, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5)),
    SOUTH_DOWN("south_down", 0, 0, new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0)),
    WEST_DOWN("west_down", 0, 180, new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0)),
    EAST_DOWN("east_down", 0, 90, new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0)),
    SOUTH_WEST("south_west", 90, 90, new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 1.0, 1.0)),
    NORTH_WEST("north_west", 90, 180, new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.5)),
    NORTH_EAST("north_east", 90, 270, new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 0.5)),
    SOUTH_EAST("south_east", 90, 0, new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 1.0, 1.0));

    public static final MouldingOrientation[] VALUES;
    private String name;
    private AxisAlignedBB bounds;
    private int x;
    private int y;

    private MouldingOrientation(String name, int x, int y, AxisAlignedBB bounds) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.bounds = bounds;
    }

    public static MouldingOrientation getFromVec(Vec3d hit, EnumFacing facing) {
        double hitXFromCenter = hit.field_72450_a - (double)OrientationUtils.CENTER_OFFSET;
        double hitYFromCenter = hit.field_72448_b - (double)OrientationUtils.CENTER_OFFSET;
        double hitZFromCenter = hit.field_72449_c - (double)OrientationUtils.CENTER_OFFSET;
        switch (facing.func_176740_k()) {
            case Y: {
                int corner = OrientationUtils.getCorner(hitXFromCenter, hitZFromCenter);
                if (corner != -1) {
                    MouldingOrientation[] corners = new MouldingOrientation[]{SOUTH_EAST, NORTH_EAST, NORTH_WEST, SOUTH_WEST};
                    return corners[corner];
                }
                if (hitYFromCenter > 0.0) {
                    if (OrientationUtils.isMax(hitXFromCenter, hitZFromCenter)) {
                        return hitXFromCenter > 0.0 ? SOUTH_DOWN : WEST_DOWN;
                    }
                    return hitZFromCenter > 0.0 ? EAST_DOWN : NORTH_DOWN;
                }
                if (OrientationUtils.isMax(hitXFromCenter, hitZFromCenter)) {
                    return hitXFromCenter > 0.0 ? SOUTH_UP : WEST_UP;
                }
                return hitZFromCenter > 0.0 ? EAST_UP : NORTH_UP;
            }
            case X: {
                int corner = OrientationUtils.getCorner(hitYFromCenter, hitZFromCenter);
                if (corner != -1) {
                    MouldingOrientation[] corners = new MouldingOrientation[]{EAST_UP, NORTH_UP, NORTH_DOWN, EAST_DOWN};
                    return corners[corner];
                }
                if (hitXFromCenter > 0.0) {
                    if (OrientationUtils.isMax(hitYFromCenter, hitZFromCenter)) {
                        return hitYFromCenter > 0.0 ? WEST_UP : WEST_DOWN;
                    }
                    return hitYFromCenter > 0.0 ? SOUTH_WEST : NORTH_WEST;
                }
                if (OrientationUtils.isMax(hitYFromCenter, hitZFromCenter)) {
                    return hitYFromCenter > 0.0 ? SOUTH_UP : SOUTH_DOWN;
                }
                return hitZFromCenter > 0.0 ? SOUTH_EAST : NORTH_EAST;
            }
            case Z: {
                int corner = OrientationUtils.getCorner(hitYFromCenter, hitXFromCenter);
                if (corner != -1) {
                    MouldingOrientation[] corners = new MouldingOrientation[]{SOUTH_UP, WEST_UP, WEST_DOWN, SOUTH_DOWN};
                    return corners[corner];
                }
                if (hitZFromCenter > 0.0) {
                    if (OrientationUtils.isMax(hitXFromCenter, hitYFromCenter)) {
                        return hitXFromCenter > 0.0 ? NORTH_EAST : NORTH_WEST;
                    }
                    return hitYFromCenter > 0.0 ? NORTH_UP : NORTH_DOWN;
                }
                if (OrientationUtils.isMax(hitXFromCenter, hitYFromCenter)) {
                    return hitXFromCenter > 0.0 ? SOUTH_EAST : SOUTH_WEST;
                }
                return hitXFromCenter > 0.0 ? EAST_UP : EAST_DOWN;
            }
        }
        return NORTH_DOWN;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation toTransformation() {
        return new TRSRTransformation(ModelRotation.func_177524_a((int)this.x, (int)this.y));
    }

    @Override
    public BaseOrientation next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    static {
        VALUES = MouldingOrientation.values();
    }
}

