/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockDirtSlab;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HCMovement
extends Feature {
    public static final UUID HCMOVEMENT_SPEED_UUID = UUID.fromString("aece6a05-d163-4871-aaf3-ebab43b0fcfa");
    public static final HashMap<Material, Float> MATERIAL_MOVEMENT = Maps.newHashMap();
    public static final HashMap<IBlockState, Float> BLOCK_OVERRIDE_MOVEMENT = Maps.newHashMap();
    public static final float DEFAULT_SPEED = 0.75f;
    public static final float FAST = 1.2f;
    public static boolean dirtpathQuality;
    public static HashMap<UUID, Float> PREVIOUS_SPEED;

    @Override
    public void setupConfig() {
        dirtpathQuality = this.loadPropBool("Dirt Paths Require Quality Shovel", "Dirt Paths require a shovel greater than stone to be created", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Change walking speed depending on the block";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MATERIAL_MOVEMENT.put(Material.field_151576_e, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.field_151575_d, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.field_151573_f, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.field_151580_n, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.field_151593_r, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.field_151594_q, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.field_151577_b, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.field_151592_s, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.field_151578_c, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.field_151571_B, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.field_151595_p, Float.valueOf(0.75f));
        MATERIAL_MOVEMENT.put(Material.field_151597_y, Float.valueOf(0.75f));
        MATERIAL_MOVEMENT.put(Material.field_151584_j, Float.valueOf(0.7f));
        MATERIAL_MOVEMENT.put(Material.field_151585_k, Float.valueOf(0.7f));
        MATERIAL_MOVEMENT.put(Material.field_151582_l, Float.valueOf(0.7f));
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.field_150425_aM.func_176223_P(), Float.valueOf(0.7f));
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.field_150351_n.func_176223_P(), Float.valueOf(1.2f));
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.field_185774_da.func_176223_P(), Float.valueOf(1.2f));
        BLOCK_OVERRIDE_MOVEMENT.put(BWMBlocks.DIRT_SLAB.func_176223_P().func_177226_a(BlockDirtSlab.VARIANT, (Comparable)((Object)BlockDirtSlab.DirtSlabType.PATH)), Float.valueOf(1.2f));
    }

    @SubscribeEvent
    public void onWalk(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            if (player.func_184218_aH()) {
                return;
            }
            float speed = 0.0f;
            if (player.field_70122_E) {
                BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u - 0.2)), MathHelper.func_76128_c((double)player.field_70161_v));
                IBlockState state = player.field_70170_p.func_180495_p(blockpos);
                speed = BLOCK_OVERRIDE_MOVEMENT.containsKey(state) ? BLOCK_OVERRIDE_MOVEMENT.get(state).floatValue() : MATERIAL_MOVEMENT.getOrDefault(state.func_185904_a(), Float.valueOf(0.75f)).floatValue();
                if (!player.field_70170_p.func_180495_p(player.func_180425_c()).func_185904_a().func_76220_a()) {
                    state = player.field_70170_p.func_180495_p(player.func_180425_c());
                    if (BLOCK_OVERRIDE_MOVEMENT.containsKey(state)) {
                        speed = BLOCK_OVERRIDE_MOVEMENT.get(state).floatValue();
                    } else if (MATERIAL_MOVEMENT.containsKey(state.func_185904_a())) {
                        speed *= MATERIAL_MOVEMENT.get(state.func_185904_a()).floatValue();
                    }
                }
                PREVIOUS_SPEED.put(player.func_146103_bH().getId(), Float.valueOf(speed));
            }
            if (speed == 0.0f) {
                speed = PREVIOUS_SPEED.getOrDefault(player.func_146103_bH().getId(), Float.valueOf(0.75f)).floatValue();
            }
            PlayerHelper.changeSpeed((EntityLivingBase)player, "HCMovement", speed, HCMOVEMENT_SPEED_UUID);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        EntityPlayer player = event.getEntity();
        float f = 1.0f;
        if (player.field_71075_bZ.field_75100_b) {
            f *= 1.1f;
        }
        IAttributeInstance iattributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        double value = iattributeinstance.func_111126_e();
        AttributeModifier mod = iattributeinstance.func_111127_a(HCMOVEMENT_SPEED_UUID);
        if (mod != null) {
            value /= 1.0 + mod.func_111164_d();
        }
        f = (float)((double)f * ((value / (double)player.field_71075_bZ.func_75094_b() + 1.0) / 2.0));
        if (player.field_71075_bZ.func_75094_b() == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() == Items.field_151031_f) {
            int i = player.func_184612_cw();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            f *= 1.0f - f1 * 0.15f;
        }
        event.setNewfov(f);
    }

    static {
        PREVIOUS_SPEED = Maps.newHashMap();
    }
}

