/*
 * Decompiled with CFR 0.152.
 */
package sporeaoc.byg.config.weight;

import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import sporeaoc.byg.config.weight.ConfigWeightManager;

public class ConfigWeight {
    private String name;
    private int weight;
    private BiomeDictionary.Type[] types;
    private ForgeConfigSpec.IntValue configWeight;

    public ConfigWeight(String name, int weight) {
        this.name = name;
        this.weight = weight;
        ConfigWeightManager.BIOMES.add(this);
    }

    public String getName() {
        return this.name;
    }

    public int getWeight() {
        return (Integer)this.configWeight.get();
    }

    public boolean shouldSpawn() {
        return (Integer)this.configWeight.get() != 0;
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " biome generation").push(this.name + "_biome");
        this.configWeight = builder.comment("weight of the biome (set to 0 to disable generation). \ndefault is 10").defineInRange("weight", this.weight, 0, 256);
        builder.pop();
    }
}

