/*
 * Decompiled with CFR 0.152.
 */
package sporeaoc.byg.registries;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import sporeaoc.byg.BYG;
import sporeaoc.byg.catalogs.BiomeCatalog;
import sporeaoc.byg.config.weight.ConfigWeightManager;

@Mod.EventBusSubscriber(modid="byg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BYGBiomeRegistry {
    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.AMARANTHFIELDS, "amaranthfields", ConfigWeightManager.amaranthfields.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.LUSH);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.ALLIUMFIELDS, "alliumfields", ConfigWeightManager.allliumfields.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.LUSH);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.ALPS, "alps", ConfigWeightManager.alps.getWeight(), true, BiomeManager.BiomeType.ICY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.BLUETAIGA, "bluetaiga", ConfigWeightManager.bluetaiga.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.BLUEGIANTTAIGA, "giantbluesprucetaiga", ConfigWeightManager.giantbluetaiga.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.BOREALFOREST, "borealforest", ConfigWeightManager.borealforest.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.DOVERMOUNTAINS, "dovermountains", ConfigWeightManager.dovermountains.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.DECIDUOUSFOREST, "deciduousforest", ConfigWeightManager.deciduousforest.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.DUNES, "dunes", ConfigWeightManager.dunes.getWeight(), true, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.GRASSLANDPLATEAU, "grasslandplateau", ConfigWeightManager.grasslandplateau.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.GUIANASHIELD, "guianashield", ConfigWeightManager.guianashield.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.JACARANDAFOREST, "jacarandaforest", ConfigWeightManager.jacarandaforest.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.PRAIRIE, "prairie", ConfigWeightManager.prairie.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.REDDESERT, "reddesert", ConfigWeightManager.reddesert.getWeight(), true, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.REDDESERTDUNES, "reddesertdunes", ConfigWeightManager.reddesertdunes.getWeight(), true, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.REDOAKFOREST, "redoakforest", ConfigWeightManager.redoakforest.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SEASONALBIRCHFOREST, "seasonalbirchforest", ConfigWeightManager.seasonalbirchforest.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SEASONALDECIDUOUSFOREST, "seasonaldeciduousforest", ConfigWeightManager.seasonaldeciduousforest.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SEASONALFOREST, "seasonalforest", ConfigWeightManager.seasonalforest.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SEASONALGIANTTAIGA, "giantseasonalsprucetaiga", ConfigWeightManager.seasonalgianttaiga.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SEASONALTAIGA, "seasonaltaiga", ConfigWeightManager.seasonaltaiga.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SHRUBLANDS, "shrublands", ConfigWeightManager.shrublands.getWeight(), true, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SNOWYBLUETAIGA, "snowybluetaiga", ConfigWeightManager.snowybluetaiga.getWeight(), true, BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.SNOWYBLUEGIANTTAIGA, "snowygiantbluetaiga", ConfigWeightManager.snowygiantbluetaiga.getWeight(), true, BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BiomeCatalog.TROPICALRAINFOREST, "tropicalrainforest", ConfigWeightManager.tropicalrainforest.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE);
        BYG.LOGGER.info("All BYG biomes registered!");
    }

    private static void registerBiome(IForgeRegistry<Biome> registry, Biome biome, String name, int weight, boolean spawn, BiomeManager.BiomeType type, BiomeDictionary.Type ... types) {
        registry.register(biome.setRegistryName("byg", name));
        if (weight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
            if (spawn) {
                BiomeManager.addSpawnBiome((Biome)biome);
            }
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        }
    }
}

