/*
 * Decompiled with CFR 0.152.
 */
package sporeaoc.byg.world.tree;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class TightTrees
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = Blocks.field_196617_K.func_176223_P();
    private static final BlockState LEAVES = Blocks.field_196642_W.func_176223_P();

    public TightTrees(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean doBlockNotifyIn) {
        super(configIn, doBlockNotifyIn);
    }

    public TightTrees() {
        super(null, true);
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundsIn) {
        int randTreeHeight = rand.nextInt(15) + rand.nextInt(2) + 10;
        int posX = position.func_177958_n();
        int posY = position.func_177956_o();
        int posZ = position.func_177952_p();
        if (posY >= 1 && posY + randTreeHeight + 1 < 256) {
            BlockPos blockpos = position.func_177977_b();
            if (!TightTrees.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos, (IPlantable)this.getSapling())) {
                return false;
            }
            if (!this.func_214615_a((IWorldGenerationBaseReader)worldIn, position, randTreeHeight)) {
                return false;
            }
            this.setDirtAt(worldIn, blockpos, position);
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            int random1 = randTreeHeight - rand.nextInt(1);
            int posY1 = 2 - rand.nextInt(1);
            int posX1 = posX;
            int posZ1 = posZ;
            int posy2 = posY + randTreeHeight - 1;
            for (int posX2LogRemover = 0; posX2LogRemover < randTreeHeight; ++posX2LogRemover) {
                if (posX2LogRemover >= random1 && posY1 > 0) {
                    posX1 += direction.func_82601_c();
                    posZ1 += direction.func_82599_e();
                    ++posY1;
                }
                int logplacer = posY + posX2LogRemover;
                int logplacer2 = posY + posX2LogRemover;
                BlockPos blockpos1 = new BlockPos(posX1, logplacer, posZ1);
                BlockPos blockposwest1 = new BlockPos(posX1 - 1, logplacer2, posZ1);
                BlockPos blockposeast1 = new BlockPos(posX1 + 1, logplacer2, posZ1);
                BlockPos blockposnorth1 = new BlockPos(posX1, logplacer2, posZ1 - 1);
                BlockPos blockpossouth1 = new BlockPos(posX1, logplacer2, posZ1 + 1);
                if (!TightTrees.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
                this.treelog(changedBlocks, worldIn, blockpos1, boundsIn);
            }
            for (int posXLeafWidth = -1; posXLeafWidth <= 1; ++posXLeafWidth) {
                for (int posZLeafWidthL0 = -2; posZLeafWidthL0 <= 0; ++posZLeafWidthL0) {
                    int leaveheight = 0;
                    this.leafs(worldIn, posX1 + posXLeafWidth, posy2 + leaveheight - 4, 1 + posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1 + posXLeafWidth, posy2 + leaveheight - 3, 1 + posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1 + posXLeafWidth, posy2 + leaveheight - 2, 1 + posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1 + posXLeafWidth, posy2 + leaveheight - 1, 1 + posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                }
            }
            boolean leaves = true;
            if (leaves) {
                this.leafs(worldIn, posX1, posy2 + 2, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 + 1, posy2, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 - 1, posy2, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2, posZ1 - 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2, posZ1 + 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 + 1, posy2, posZ1 + 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 - 1, posy2, posZ1 - 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 - 1, posy2, posZ1 - 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 + 1, posy2, posZ1 - 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 - 1, posy2, posZ1 + 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 + 1, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 - 1, posy2 + 1, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 + 1, posy2 + 1, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 + 1, posZ1 - 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 + 1, posZ1 + 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 + 2, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 - 1, posy2 + 2, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 + 1, posy2 + 2, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 + 2, posZ1 - 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 + 2, posZ1 + 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 - 4, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 - 1, posy2 - 4, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1 + 1, posy2 - 4, posZ1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 - 4, posZ1 - 1, boundsIn, changedBlocks);
                this.leafs(worldIn, posX1, posy2 - 4, posZ1 + 1, boundsIn, changedBlocks);
            }
            return true;
        }
        return false;
    }

    private boolean func_214615_a(IWorldGenerationBaseReader p_214615_1_, BlockPos p_214615_2_, int p_214615_3_) {
        int i = p_214615_2_.func_177958_n();
        int j = p_214615_2_.func_177956_o();
        int k = p_214615_2_.func_177952_p();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l <= p_214615_3_ + 1; ++l) {
            int i1 = 0;
            if (l == 0) {
                i1 = 20;
            }
            if (l >= p_214615_3_ - 1) {
                i1 = 1;
            }
            for (int j1 = -i1; j1 <= i1; ++j1) {
                for (int k1 = -i1; k1 <= i1; ++k1) {
                    if (TightTrees.func_214587_a((IWorldGenerationBaseReader)p_214615_1_, (BlockPos)blockpos$mutableblockpos.func_181079_c(i + j1, j + l, k + k1))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void treelog(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (TightTrees.func_214587_a((IWorldGenerationBaseReader)reader, (BlockPos)pos)) {
            this.func_208520_a(setlogblock, (IWorldWriter)reader, pos, LOG, boundingBox);
        }
    }

    private void leafs(IWorldGenerationReader reader, int p_214617_2_, int p_214617_3_, int p_214617_4_, MutableBoundingBox p_214617_5_, Set<BlockPos> p_214617_6_) {
        BlockPos blockpos = new BlockPos(p_214617_2_, p_214617_3_, p_214617_4_);
        if (TightTrees.func_214574_b((IWorldGenerationBaseReader)reader, (BlockPos)blockpos)) {
            this.func_208520_a(p_214617_6_, (IWorldWriter)reader, blockpos, LEAVES, p_214617_5_);
        }
    }
}

