/*
 * Decompiled with CFR 0.152.
 */
package sporeaoc.byg.world.tree;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class TreeName
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = Blocks.field_196617_K.func_176223_P();
    private static final BlockState LEAVES = Blocks.field_196642_W.func_176223_P();

    public TreeName() {
        super(null, true);
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundsIn) {
        int randTreeHeight = rand.nextInt(3) + rand.nextInt(3) + 10;
        int posX = position.func_177958_n();
        int posY = position.func_177956_o();
        int posZ = position.func_177952_p();
        if (posY >= 1 && posY + randTreeHeight + 1 < 256) {
            BlockPos checkGround = position.func_177977_b();
            if (!TreeName.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)checkGround, (IPlantable)this.getSapling())) {
                return false;
            }
            if (!this.doesTreeFit((IWorldGenerationBaseReader)worldIn, position, randTreeHeight)) {
                return false;
            }
            this.setDirtAt(worldIn, checkGround, position);
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            int randTreeHeight2 = randTreeHeight - rand.nextInt(1);
            int posY2 = 2 - rand.nextInt(1);
            int posX2 = posX;
            int posZ2 = posZ;
            int topTrunkHeight = posY + randTreeHeight - 1;
            for (int trunkBottom = 0; trunkBottom < randTreeHeight; ++trunkBottom) {
                if (trunkBottom >= randTreeHeight2 && posY2 < 0) {
                    posX2 += direction.func_82601_c();
                    posZ2 += direction.func_82599_e();
                    ++posY2;
                }
                int logplacer = posY + trunkBottom;
                BlockPos trunkPos1 = new BlockPos(posX2, logplacer, posZ2);
                this.treelog(changedBlocks, worldIn, trunkPos1, boundsIn);
                this.treelog(changedBlocks, worldIn, trunkPos1.func_177978_c(), boundsIn);
                this.treelog(changedBlocks, worldIn, trunkPos1.func_177974_f(), boundsIn);
                this.treelog(changedBlocks, worldIn, trunkPos1.func_177978_c().func_177974_f(), boundsIn);
                this.treelog(changedBlocks, worldIn, trunkPos1, boundsIn);
                this.treelog(changedBlocks, worldIn, trunkPos1.func_177964_d(5), boundsIn);
                this.treelog(changedBlocks, worldIn, trunkPos1.func_177965_g(1), boundsIn);
                this.treelog(changedBlocks, worldIn, trunkPos1.func_177964_d(1).func_177965_g(1), boundsIn);
            }
            for (int posXLeafSize = -2; posXLeafSize <= 2; ++posXLeafSize) {
                for (int posZLeafSize = -2; posZLeafSize <= 2; ++posZLeafSize) {
                    this.leafs(worldIn, posX2 + posXLeafSize, topTrunkHeight, posZ2 + posZLeafSize, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2, topTrunkHeight + 1, posZ2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 + 1, topTrunkHeight + 1, posZ2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 - 1, topTrunkHeight + 1, posZ2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2, topTrunkHeight + 1, posZ2 + 1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2, topTrunkHeight + 1, posZ2 - 1, boundsIn, changedBlocks);
                }
            }
            return true;
        }
        return false;
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 0;
            for (int xDistance = -distance; xDistance <= distance; ++xDistance) {
                for (int zDistance = -distance; zDistance <= distance; ++zDistance) {
                    if (TreeName.canTreePlace(reader, (BlockPos)position.func_181079_c(x + xDistance, y + yOffset, z + zDistance))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void treelog(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (TreeName.canTreePlace((IWorldGenerationBaseReader)reader, pos)) {
            this.func_208520_a(setlogblock, (IWorldWriter)reader, pos, LOG, boundingBox);
        }
    }

    private void leafs(IWorldGenerationReader reader, int x, int y, int z, MutableBoundingBox boundingBox, Set<BlockPos> blockPos) {
        BlockPos leafpos = new BlockPos(x, y, z);
        if (TreeName.func_214574_b((IWorldGenerationBaseReader)reader, (BlockPos)leafpos)) {
            this.func_208520_a(blockPos, (IWorldWriter)reader, leafpos, LEAVES, boundingBox);
        }
    }

    protected static boolean canTreePlace(IWorldGenerationBaseReader genBaseReader, BlockPos blockPos) {
        return TreeName.func_214587_a((IWorldGenerationBaseReader)genBaseReader, (BlockPos)blockPos);
    }
}

