/*
 * Decompiled with CFR 0.152.
 */
package sporeaoc.byg.worldtype.noise;

import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class XorShift {
    private static final int SEED_TABLE_SPACE = 1024;
    private static final int SEED_TABLE_SIZE = 3072;
    private final long[] seeds;

    public static XorShift create() {
        return new XorShift(ThreadLocalRandom.current().nextLong());
    }

    public static XorShift create(long seed) {
        return new XorShift(seed);
    }

    private XorShift(long seed) {
        Random random = new Random(seed);
        this.seeds = new long[3072];
        for (int i = 0; i < 3072; ++i) {
            this.seeds[i] = random.nextLong();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof XorShift) {
            XorShift o = (XorShift)obj;
            return Objects.equals(this.seeds, o.seeds);
        }
        return false;
    }

    public static long fastAbs(long n) {
        long mask = n >> 63;
        return n + mask ^ mask;
    }

    public Instance getInstance() {
        return new Instance();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.seeds});
    }

    public final class Instance {
        private long x;
        private long z;

        private Instance() {
            this.setSeed(0L, 0L);
        }

        public double nextDouble() {
            return (double)(this.nextLong() >>> 2) * 2.168404344971009E-19;
        }

        public long nextLong() {
            long t = this.x ^ this.x << 13;
            this.x = this.z;
            this.z = this.z ^ this.z >>> 3 ^ (t ^ t >>> 19);
            return this.z;
        }

        public void setSeed(long x, long z) {
            this.x = XorShift.this.seeds[(int)(XorShift.fastAbs(x) % 1024L)];
            this.z = XorShift.this.seeds[(int)(XorShift.fastAbs(z) % 1024L) + 1024 + 1024];
        }
    }
}

