/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tterrag.blur.Blur;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    private static Class configClass;
    private static String translationPrefix;
    private static Path path;
    private static final Gson gson;

    public static void init(String modid, Class<?> config) {
        translationPrefix = modid + ".midnightconfig.";
        path = FabricLoader.getInstance().getConfigDir().resolve(modid + ".json");
        configClass = config;
        for (Field field : config.getFields()) {
            Entry e;
            Class<?> type = field.getType();
            EntryInfo info = new EntryInfo();
            try {
                e = field.getAnnotation(Entry.class);
            }
            catch (Exception ignored) {
                continue;
            }
            info.width = e.width();
            info.field = field;
            if (type == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, e.min(), e.max(), true);
            } else if (type == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (type == String.class) {
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (type == Boolean.TYPE) {
                Function<Object, class_2561> func = value -> new class_2585((Boolean)value != false ? "True" : "False").method_27692((Boolean)value != false ? class_124.field_1060 : class_124.field_1061);
                info.widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            } else {
                if (!type.isEnum()) continue;
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, class_2561> func = value -> new class_2588(translationPrefix + "enum." + type.getSimpleName() + "." + info.value.toString());
                info.widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            }
            entries.add(info);
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            try {
                info.dynamicTooltip = config.getMethod(e.dynamicTooltip(), new Class[0]);
                info.dynamicTooltip.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            MidnightConfig.write();
        }
        for (EntryInfo info : entries) {
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (t, b) -> s -> {
            if (!(s = s.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            System.out.println(isNumber ^ s.isEmpty());
            System.out.println(!s.equals("-") && !s.equals("."));
            info.error = null;
            if (!(isNumber && s.isEmpty() || s.equals("-") || s.equals(".") || !(Double.parseDouble(s) < 9.99999999E8))) {
                value = (Number)f.apply((String)s);
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<class_342, class_2585>((class_342)t, new class_2585(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max)));
            }
            info.tempValue = s;
            t.method_1868(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.field_22763 = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                info.value = isNumber ? value : s;
            }
            return true;
        };
    }

    public static void write() {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson(configClass.newInstance()).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class_437 getScreen(class_437 parent) {
        return new TinyConfigScreen(parent);
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).setPrettyPrinting().create();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public String dynamicTooltip() default "";

        public int width() default 100;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;
    }

    private static class TinyConfigScreen
    extends class_437 {
        private final class_437 parent;
        int aniX;

        protected TinyConfigScreen(class_437 parent) {
            super((class_2561)new class_2588(translationPrefix + "title"));
            this.aniX = this.field_22789 / 2;
            this.parent = parent;
        }

        public void method_25393() {
            for (EntryInfo info : entries) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            Blur.INSTANCE.onScreenChange(this);
        }

        protected void method_25426() {
            super.method_25426();
            this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20, class_5244.field_24335, button -> {
                try {
                    gson.fromJson((Reader)Files.newBufferedReader(path), configClass);
                }
                catch (Exception e) {
                    MidnightConfig.write();
                }
                for (EntryInfo info : entries) {
                    try {
                        info.value = info.field.get(null);
                        info.tempValue = info.value.toString();
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            class_4185 done = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20, class_5244.field_24334, button -> {
                for (EntryInfo info : entries) {
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                MidnightConfig.write();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            int y = 45;
            for (EntryInfo info : entries) {
                Map.Entry widget;
                this.method_25411((class_339)new class_4185(this.field_22789 - 155, y, 40, 20, (class_2561)new class_2585("Reset").method_27692(class_124.field_1061), button -> {
                    info.value = info.defaultValue;
                    info.tempValue = info.value.toString();
                    Objects.requireNonNull(this.field_22787).method_1507((class_437)this);
                }));
                if (info.widget instanceof Map.Entry) {
                    widget = (Map.Entry)info.widget;
                    this.method_25411((class_339)new class_4185(this.field_22789 - 110, y, info.width, 20, (class_2561)((Function)widget.getValue()).apply(info.value), (class_4185.class_4241)widget.getKey()));
                } else {
                    widget = (class_342)this.method_25411((class_339)new class_342(this.field_22793, this.field_22789 - 110, y, info.width, 20, null));
                    widget.method_1852(info.tempValue);
                    Predicate processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.method_1890(processor);
                    this.field_22786.add(widget);
                }
                y += 25;
            }
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.method_25420(matrices);
            if (this.aniX < this.field_22789 / 2) {
                this.aniX += 40;
            }
            int stringWidth = (int)((float)this.field_22785.getString().length() * 2.75f);
            this.method_25296(matrices, this.field_22789 / 2 - stringWidth, 10, this.field_22789 / 2 + stringWidth, 29, -1072689136, -804253680);
            if (this.field_22787.field_1687 == null) {
                this.method_25296(matrices, this.field_22789 / 2 - this.aniX, 35, this.field_22789 / 2 + this.aniX, this.field_22790 - 40, -1072689136, -804253680);
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
            TinyConfigScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
            int y = 40;
            for (EntryInfo info : entries) {
                TinyConfigScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2588(translationPrefix + info.field.getName()), (int)12, (int)(y + 10), (int)0xFFFFFF);
                if (info.error != null && info.error.getKey().method_25405((double)mouseX, (double)mouseY)) {
                    this.method_25424(matrices, info.error.getValue(), mouseX, mouseY);
                } else if (mouseY >= y && mouseY < y + 25) {
                    String key;
                    if (info.dynamicTooltip != null) {
                        try {
                            this.method_30901(matrices, (List)info.dynamicTooltip.invoke(null, entries), mouseX, mouseY);
                            y += 25;
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (class_1074.method_4663((String)(key = translationPrefix + info.field.getName() + ".tooltip"))) {
                        ArrayList<class_2585> list = new ArrayList<class_2585>();
                        for (String str : class_1074.method_4662((String)key, (Object[])new Object[0]).split("\n")) {
                            list.add(new class_2585(str));
                        }
                        this.method_30901(matrices, list, mouseX, mouseY);
                    }
                }
                y += 25;
            }
        }
    }

    protected static class EntryInfo {
        Field field;
        Object widget;
        int width;
        Method dynamicTooltip;
        Map.Entry<class_342, class_2561> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;

        protected EntryInfo() {
        }
    }
}

