/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tterrag.blur.mixin.MixinGameRenderer;
import com.tterrag.blur.util.ReflectionHelper;
import com.tterrag.blur.util.ShaderResourcePack;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1075;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_279;
import net.minecraft.class_283;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3281;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3296;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_757;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;

public class Blur
implements ClientModInitializer {
    public static final String MODID = "blur";
    public static final String MOD_NAME = "Blur";
    public static final String VERSION = "@VERSION@";
    private Field _listShaders;
    private long start;
    public ConfigJson configs = new ConfigJson();
    public int colorFirst;
    public int colorSecond;
    private ShaderResourcePack dummyPack = new ShaderResourcePack();
    public static Blur instance;

    public Blur() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        class_3283 rps = (class_3283)ReflectionHelper.getValue(class_310.class, class_310.method_1551(), "field_1715", "resourcePackContainerManager");
        rps.method_14443(new class_3285(){

            public <T extends class_3288> void method_14453(Map<String, T> var1, class_3288.class_3290<T> factory) {
                class_1011 img = null;
                try {
                    img = class_1011.method_4309((InputStream)Blur.this.dummyPack.method_14410("icon.png"));
                }
                catch (IOException e) {
                    LogManager.getLogger().error("Could not load blur's icon.png", (Throwable)e);
                }
                class_1075 var3 = new class_1075(Blur.MODID, true, () -> Blur.this.dummyPack, (class_2561)new class_2585(Blur.this.dummyPack.method_14409()), (class_2561)new class_2585("Default shaders for Blur"), class_3281.field_14224, class_3288.class_3289.field_14281, true, img);
                if (var3 != null) {
                    var1.put(Blur.MODID, var3);
                }
            }
        });
        instance = this;
    }

    public void onInitializeClient() {
        File configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "blur.json");
        try {
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                Files.write(configFile.toPath(), new GsonBuilder().setPrettyPrinting().create().toJson((Object)this.configs).getBytes(), StandardOpenOption.CREATE_NEW);
            } else {
                this.configs = (ConfigJson)new Gson().fromJson((Reader)new FileReader(configFile), ConfigJson.class);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.colorFirst = Integer.parseUnsignedInt(this.configs.gradientStartColor, 16);
        this.colorSecond = Integer.parseUnsignedInt(this.configs.gradientEndColor, 16);
    }

    public void registerReloadListeners(class_3296 manager) {
        manager.method_14475((class_3262)this.dummyPack);
    }

    public void onScreenChange(class_437 newGui) {
        if (this._listShaders == null) {
            this._listShaders = ReflectionHelper.getField(class_279.class, "field_1497", "passes");
        }
        if (class_310.method_1551().field_1687 != null) {
            boolean excluded;
            class_757 er = class_310.method_1551().field_1773;
            boolean bl = excluded = newGui == null || ArrayUtils.contains((Object[])this.configs.blurExclusions, (Object)newGui.getClass().getName());
            if (!er.method_3175() && !excluded) {
                ((MixinGameRenderer)er).invokeLoadShader(new class_2960("shaders/post/fade_in_blur.json"));
                this.start = System.currentTimeMillis();
            } else if (er.method_3175() && excluded) {
                er.method_3207();
            }
        }
    }

    public int getRadius() {
        return this.configs.radius;
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.start) / (float)this.configs.fadeTimeMillis, 1.0f);
    }

    public void onPostRenderTick() {
        if (class_310.method_1551().field_1755 != null && class_310.method_1551().field_1773.method_3175()) {
            class_279 sg = class_310.method_1551().field_1773.method_3183();
            try {
                List shaders = (List)this._listShaders.get(sg);
                for (class_283 s : shaders) {
                    class_284 su = s.method_1295().method_1271("Progress");
                    if (su == null) continue;
                    su.method_1251(this.getProgress());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getBackgroundColor(boolean second) {
        int color = second ? this.colorSecond : this.colorFirst;
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int g = color & 0xFF;
        float prog = instance.getProgress();
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }

    static class ConfigJson {
        String[] blurExclusions = new String[]{class_408.class.getName()};
        int fadeTimeMillis = 200;
        int radius = 8;
        String gradientStartColor = "75000000";
        String gradientEndColor = "75000000";

        ConfigJson() {
        }
    }
}

