/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.darkhax.botanypots.fertilizer.FertilizerInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class BotanyPotHelper {
    @Nullable
    public static Map<ResourceLocation, SoilInfo> getSoilData(RecipeManager manager) {
        if (manager != null) {
            return WorldUtils.getRecipes(BotanyPots.instance.getContent().getRecipeTypeSoil(), (RecipeManager)manager);
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static Map<ResourceLocation, CropInfo> getCropData(RecipeManager manager) {
        if (manager != null) {
            return WorldUtils.getRecipes(BotanyPots.instance.getContent().getRecipeTypeCrop(), (RecipeManager)manager);
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static Map<ResourceLocation, FertilizerInfo> getFertilizerData(RecipeManager manager) {
        if (manager != null) {
            return WorldUtils.getRecipes(BotanyPots.instance.getContent().getRecipeTypeFertilizer(), (RecipeManager)manager);
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static SoilInfo getSoil(RecipeManager manager, ResourceLocation id) {
        if (manager != null && id != null) {
            return (SoilInfo)WorldUtils.getRecipes(BotanyPots.instance.getContent().getRecipeTypeSoil(), (RecipeManager)manager).get(id);
        }
        return null;
    }

    @Nullable
    public static CropInfo getCrop(RecipeManager manager, ResourceLocation id) {
        if (manager != null && id != null) {
            return (CropInfo)WorldUtils.getRecipes(BotanyPots.instance.getContent().getRecipeTypeCrop(), (RecipeManager)manager).get(id);
        }
        return null;
    }

    @Nullable
    public static FertilizerInfo getFertilizer(RecipeManager manager, ResourceLocation id) {
        if (manager != null && id != null) {
            return (FertilizerInfo)WorldUtils.getRecipes(BotanyPots.instance.getContent().getRecipeTypeFertilizer(), (RecipeManager)manager).get(id);
        }
        return null;
    }

    public static int getRequiredGrowthTicks(@Nullable CropInfo crop, @Nullable SoilInfo soil) {
        return crop == null || soil == null ? -1 : crop.getGrowthTicksForSoil(soil);
    }

    @Nullable
    public static SoilInfo getSoilForItem(World world, ItemStack item) {
        for (SoilInfo soilInfo : WorldUtils.getRecipeList(BotanyPots.instance.getContent().getRecipeTypeSoil(), (RecipeManager)world.func_199532_z())) {
            if (!soilInfo.getIngredient().test(item)) continue;
            return soilInfo;
        }
        return null;
    }

    @Nullable
    public static CropInfo getCropForItem(World world, ItemStack item) {
        for (CropInfo cropInfo : WorldUtils.getRecipeList(BotanyPots.instance.getContent().getRecipeTypeCrop(), (RecipeManager)world.func_199532_z())) {
            if (!cropInfo.getSeed().test(item)) continue;
            return cropInfo;
        }
        return null;
    }

    public static boolean isSoilValidForCrop(SoilInfo soil, CropInfo crop) {
        for (String soilCategory : soil.getCategories()) {
            for (String cropCategory : crop.getSoilCategories()) {
                if (!soilCategory.equalsIgnoreCase(cropCategory)) continue;
                return true;
            }
        }
        return false;
    }

    public static NonNullList<ItemStack> getHarvestStacks(World world, CropInfo crop) {
        NonNullList drops = NonNullList.func_191196_a();
        for (HarvestEntry cropEntry : crop.getResults()) {
            int rolls;
            if (!(world.field_73012_v.nextFloat() <= cropEntry.getChance()) || (rolls = MathsUtils.nextIntInclusive((Random)world.field_73012_v, (int)cropEntry.getMinRolls(), (int)cropEntry.getMaxRolls())) <= 0) continue;
            for (int roll = 0; roll < rolls; ++roll) {
                drops.add((Object)cropEntry.getItem().func_77946_l());
            }
        }
        return drops;
    }

    public static int getFertilizerTicks(ItemStack item, World world) {
        for (FertilizerInfo fertilizer : WorldUtils.getRecipeList(BotanyPots.instance.getContent().getRecipeTypeFertilizer(), (RecipeManager)world.func_199532_z())) {
            if (!fertilizer.getIngredient().test(item)) continue;
            return fertilizer.getTicksToGrow(world.field_73012_v);
        }
        return -1;
    }

    public static ITextComponent getSoilName(@Nullable SoilInfo soil) {
        return soil != null ? soil.getRenderState().func_177230_c().func_200291_n() : Blocks.field_150350_a.func_200291_n();
    }

    public static ITextComponent getCropName(@Nullable CropInfo crop) {
        return crop != null ? crop.getDisplayState().func_177230_c().func_200291_n() : Blocks.field_150350_a.func_200291_n();
    }
}

