/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.CropSerializer;
import net.darkhax.botanypots.fertilizer.FertilizerInfo;
import net.darkhax.botanypots.fertilizer.FertilizerSerializer;
import net.darkhax.botanypots.soil.SoilInfo;
import net.darkhax.botanypots.soil.SoilSerializer;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;

public class Content {
    private final IRecipeType<SoilInfo> recipeTypeSoil;
    private final IRecipeSerializer<SoilInfo> recipeSerializerSoil;
    private final IRecipeType<CropInfo> recipeTypeCrop;
    private final IRecipeSerializer<CropInfo> recipeSerializerCrop;
    private final IRecipeType<FertilizerInfo> recipeTypeFertilizer;
    private final IRecipeSerializer<FertilizerInfo> recipeSerializerFertilizer;
    private final TileEntityType<TileEntityBotanyPot> tileBotanyPot;
    private final Block basicBotanyPotBlock;
    private final List<Block> botanyPots = new ArrayList<Block>();

    public Content(RegistryHelper registry) {
        this.recipeTypeSoil = registry.registerRecipeType("soil");
        this.recipeSerializerSoil = registry.registerRecipeSerializer((IRecipeSerializer)SoilSerializer.INSTANCE, "soil");
        this.recipeTypeCrop = registry.registerRecipeType("crop");
        this.recipeSerializerCrop = registry.registerRecipeSerializer((IRecipeSerializer)CropSerializer.INSTANCE, "crop");
        this.recipeTypeFertilizer = registry.registerRecipeType("fertilizer");
        this.recipeSerializerFertilizer = registry.registerRecipeSerializer((IRecipeSerializer)FertilizerSerializer.INSTANCE, "fertilizer");
        this.basicBotanyPotBlock = registry.registerBlock((Block)new BlockBotanyPot(), "botany_pot");
        this.botanyPots.add(this.basicBotanyPotBlock);
        for (DyeColor dyeColor : DyeColor.values()) {
            this.botanyPots.add(registry.registerBlock((Block)new BlockBotanyPot(), dyeColor.func_176610_l() + "_botany_pot"));
        }
        this.botanyPots.add(registry.registerBlock((Block)new BlockBotanyPot(true), "hopper_botany_pot"));
        for (DyeColor dyeColor : DyeColor.values()) {
            this.botanyPots.add(registry.registerBlock((Block)new BlockBotanyPot(true), "hopper_" + dyeColor.func_176610_l() + "_botany_pot"));
        }
        this.tileBotanyPot = registry.registerTileEntity(TileEntityBotanyPot::new, "botany_pot", this.botanyPots.toArray(new Block[0]));
    }

    public TileEntityType<TileEntityBotanyPot> getPotTileType() {
        return this.tileBotanyPot;
    }

    public Block getBasicBotanyPot() {
        return this.basicBotanyPotBlock;
    }

    public IRecipeType<SoilInfo> getRecipeTypeSoil() {
        return this.recipeTypeSoil;
    }

    public IRecipeSerializer<SoilInfo> getRecipeSerializerSoil() {
        return this.recipeSerializerSoil;
    }

    public IRecipeType<FertilizerInfo> getRecipeTypeFertilizer() {
        return this.recipeTypeFertilizer;
    }

    public IRecipeSerializer<FertilizerInfo> getRecipeSerializerFertilizer() {
        return this.recipeSerializerFertilizer;
    }

    public IRecipeType<CropInfo> getRecipeTypeCrop() {
        return this.recipeTypeCrop;
    }

    public IRecipeSerializer<CropInfo> getRecipeSerializerCrop() {
        return this.recipeSerializerCrop;
    }
}

