/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.Collection;
import java.util.Optional;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketUtils {
    public static BlockState deserializeBlockState(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block != null) {
            int size = buffer.readInt();
            BlockState state = block.func_176223_P();
            for (int i = 0; i < size; ++i) {
                Optional propValue;
                String propName = buffer.func_218666_n();
                String value = buffer.func_218666_n();
                IProperty blockProperty = block.func_176194_O().func_185920_a(propName);
                if (blockProperty == null || !(propValue = blockProperty.func_185929_b(value)).isPresent()) continue;
                try {
                    state = (BlockState)state.func_206870_a(blockProperty, (Comparable)propValue.get());
                    continue;
                }
                catch (Exception e) {
                    Bookshelf.LOG.error("Failed to read state for block {}. The mod that adds this block has issues.", (Object)block.getRegistryName());
                    Bookshelf.LOG.catching((Throwable)e);
                }
            }
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static void serializeBlockState(PacketBuffer buffer, BlockState state) {
        buffer.func_192572_a(state.func_177230_c().getRegistryName());
        Collection properties = state.func_206869_a();
        buffer.writeInt(properties.size());
        for (IProperty property : properties) {
            buffer.func_180714_a(property.func_177701_a());
            buffer.func_180714_a(state.func_177229_b(property).toString());
        }
    }

    public static void serializeStringArray(PacketBuffer buffer, String[] strings) {
        buffer.writeInt(strings.length);
        for (String string : strings) {
            buffer.func_180714_a(string);
        }
    }

    public static String[] deserializeStringArray(PacketBuffer buffer) {
        String[] strings = new String[buffer.readInt()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = buffer.func_218666_n();
        }
        return strings;
    }

    public static void serializeStringCollection(PacketBuffer buffer, Collection<String> strings) {
        buffer.writeInt(strings.size());
        for (String string : strings) {
            buffer.func_180714_a(string);
        }
    }

    public static void deserializeStringCollection(PacketBuffer buffer, Collection<String> toFill) {
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            toFill.add(buffer.func_218666_n());
        }
    }
}

