/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBotanyPot
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final Block.Properties properties = Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(1.25f, 4.2f);
    private final boolean hopper;
    private static final ITextComponent TOOLTIP_NORMAL = new TranslationTextComponent("botanypots.tooltip.pot.normal", new Object[0]).func_211708_a(TextFormatting.GRAY);
    private static final ITextComponent TOOLTIP_HOPPER = new TranslationTextComponent("botanypots.tooltip.pot.hopper", new Object[0]).func_211708_a(TextFormatting.GRAY);

    public BlockBotanyPot() {
        this(false);
    }

    public BlockBotanyPot(boolean hopper) {
        super(properties);
        this.hopper = hopper;
    }

    public boolean isHopper() {
        return this.hopper;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            if (player.func_70093_af()) {
                CropInfo crop = pot.getCrop();
                if (crop != null) {
                    ItemStack seedStack = crop.getRandomSeed();
                    if (!seedStack.func_190926_b() && pot.canSetCrop(null)) {
                        pot.setCrop(null);
                        BlockBotanyPot.dropItem(seedStack.func_77946_l(), world, pos);
                        return true;
                    }
                } else {
                    ItemStack soilStack;
                    SoilInfo soil = pot.getSoil();
                    if (soil != null && !(soilStack = soil.getRandomSoilBlock()).func_190926_b() && pot.canSetSoil(null)) {
                        pot.setSoil(null);
                        BlockBotanyPot.dropItem(soilStack.func_77946_l(), world, pos);
                        return true;
                    }
                }
            } else {
                ItemStack heldItem = player.func_184586_b(hand);
                if (!heldItem.func_190926_b()) {
                    int fertilizerGrowthTicks;
                    if (pot.getSoil() == null) {
                        SoilInfo soilForStack = BotanyPotHelper.getSoilForItem(world, heldItem);
                        if (soilForStack != null && pot.canSetSoil(soilForStack)) {
                            pot.setSoil(soilForStack);
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            return true;
                        }
                    } else if (pot.getCrop() == null) {
                        CropInfo cropForStack = BotanyPotHelper.getCropForItem(world, heldItem);
                        if (cropForStack != null && BotanyPotHelper.isSoilValidForCrop(pot.getSoil(), cropForStack) && pot.canSetCrop(cropForStack)) {
                            pot.setCrop(cropForStack);
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            return true;
                        }
                    } else if (!pot.canHarvest() && (fertilizerGrowthTicks = BotanyPotHelper.getFertilizerTicks(heldItem, world)) > -1) {
                        pot.addGrowth(fertilizerGrowthTicks);
                        if (!world.field_72995_K) {
                            world.func_217379_c(2005, tile.func_174877_v(), 0);
                        }
                        if (!player.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                        return true;
                    }
                }
                if (!this.isHopper() && pot.canHarvest()) {
                    pot.resetGrowthTime();
                    for (ItemStack stack : BotanyPotHelper.getHarvestStacks(world, pot.getCrop())) {
                        BlockBotanyPot.dropItem(stack, world, pos);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityBotanyPot();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tileEntity;
            if (pot.getSoil() != null) {
                BlockBotanyPot.dropItem(pot.getSoil().getRandomSoilBlock(), worldIn, pos);
            }
            if (pot.getCrop() != null) {
                BlockBotanyPot.dropItem(pot.getCrop().getRandomSeed(), worldIn, pos);
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public static void dropItem(ItemStack item, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            double offsetX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offsetY = (double)(world.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double offsetZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity droppedItemEntity = new ItemEntity(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, item);
            droppedItemEntity.func_174869_p();
            world.func_217376_c((Entity)droppedItemEntity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.isHopper() ? TOOLTIP_HOPPER : TOOLTIP_NORMAL);
    }
}

