/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.tileentity;

import javax.annotation.Nullable;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.darkhax.bookshelf.util.InventoryUtils;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityBotanyPot
extends TileEntityBasicTickable {
    @Nullable
    private SoilInfo soil;
    @Nullable
    private CropInfo crop;
    private int totalGrowthTicks;
    private int currentGrowthTicks;

    public TileEntityBotanyPot() {
        super(BotanyPots.instance.getContent().getPotTileType());
    }

    public boolean canSetSoil(@Nullable SoilInfo newSoil) {
        return newSoil == null || this.getSoil() == null;
    }

    public void setSoil(@Nullable SoilInfo newSoil) {
        this.soil = newSoil;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public boolean canSetCrop(@Nullable CropInfo newCrop) {
        return newCrop == null || this.getSoil() != null && this.getCrop() == null;
    }

    public void setCrop(@Nullable CropInfo newCrop) {
        this.crop = newCrop;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    @Nullable
    public SoilInfo getSoil() {
        return this.soil;
    }

    @Nullable
    public CropInfo getCrop() {
        return this.crop;
    }

    public int getTotalGrowthTicks() {
        return this.totalGrowthTicks;
    }

    public int getCurrentGrowthTicks() {
        return this.currentGrowthTicks;
    }

    public boolean canHarvest() {
        return this.crop != null && this.getTotalGrowthTicks() > 0 && this.getCurrentGrowthTicks() >= this.getTotalGrowthTicks();
    }

    public void resetGrowthTime() {
        this.totalGrowthTicks = BotanyPotHelper.getRequiredGrowthTicks(this.getCrop(), this.getSoil());
        this.currentGrowthTicks = 0;
        if (this.soil != null) {
            this.soil = BotanyPotHelper.getSoil(BotanyPots.instance.getActiveRecipeManager(), this.soil.func_199560_c());
            if (this.soil == null) {
                this.crop = null;
            }
        }
        if (this.crop != null) {
            this.crop = BotanyPotHelper.getCrop(BotanyPots.instance.getActiveRecipeManager(), this.crop.func_199560_c());
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void addGrowth(int ticksToGrow) {
        this.currentGrowthTicks += ticksToGrow;
        if (this.currentGrowthTicks > this.totalGrowthTicks) {
            this.currentGrowthTicks = this.totalGrowthTicks;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public float getGrowthPercent() {
        if (this.totalGrowthTicks == -1 || this.currentGrowthTicks == -1) {
            return 0.0f;
        }
        return (float)this.currentGrowthTicks / (float)this.totalGrowthTicks;
    }

    public void onTileTick() {
        if (this.soil != null && this.crop != null) {
            if (this.currentGrowthTicks >= this.totalGrowthTicks) {
                IItemHandler inventory;
                Block block = this.func_195044_w().func_177230_c();
                if (block instanceof BlockBotanyPot && ((BlockBotanyPot)block).isHopper() && (inventory = InventoryUtils.getInventory((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP)) != EmptyHandler.INSTANCE && !this.field_145850_b.field_72995_K) {
                    boolean didAutoHarvest = false;
                    block0: for (ItemStack item : BotanyPotHelper.getHarvestStacks(this.field_145850_b, this.getCrop())) {
                        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                            if (!inventory.isItemValid(slot, item) || inventory.insertItem(slot, item, true).func_190916_E() == item.func_190916_E()) continue;
                            inventory.insertItem(slot, item, false);
                            didAutoHarvest = true;
                            continue block0;
                        }
                    }
                    if (didAutoHarvest) {
                        this.resetGrowthTime();
                    }
                }
            } else if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
                ++this.currentGrowthTicks;
            }
        } else {
            this.totalGrowthTicks = -1;
            this.currentGrowthTicks = -1;
        }
    }

    public void serialize(CompoundNBT dataTag) {
        if (this.soil != null) {
            dataTag.func_74778_a("Soil", this.soil.func_199560_c().toString());
            if (this.crop != null) {
                dataTag.func_74778_a("Crop", this.crop.func_199560_c().toString());
                dataTag.func_74768_a("GrowthTicks", this.currentGrowthTicks);
            }
        }
    }

    public void deserialize(CompoundNBT dataTag) {
        if (dataTag.func_74764_b("Soil")) {
            String rawSoilId = dataTag.func_74779_i("Soil");
            ResourceLocation soilId = ResourceLocation.func_208304_a((String)rawSoilId);
            if (soilId != null) {
                SoilInfo foundSoil = BotanyPotHelper.getSoil(BotanyPots.instance.getActiveRecipeManager(), soilId);
                if (foundSoil != null) {
                    this.soil = foundSoil;
                    if (dataTag.func_74764_b("Crop")) {
                        String rawCropId = dataTag.func_74779_i("Crop");
                        ResourceLocation cropId = ResourceLocation.func_208304_a((String)rawCropId);
                        if (cropId != null) {
                            CropInfo cropInfo = BotanyPotHelper.getCrop(BotanyPots.instance.getActiveRecipeManager(), cropId);
                            if (cropInfo != null) {
                                this.crop = cropInfo;
                                this.currentGrowthTicks = dataTag.func_74762_e("GrowthTicks");
                                this.totalGrowthTicks = this.crop.getGrowthTicksForSoil(this.soil);
                            } else {
                                BotanyPots.LOGGER.error("Botany Pot at {} had a crop of type {} but that crop does not exist. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                            }
                        } else {
                            BotanyPots.LOGGER.error("Botany Pot at {} has an invalid crop Id of {}. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                        }
                    }
                } else {
                    BotanyPots.LOGGER.error("Botany Pot at {} had a soil of type {} which no longer exists. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
                }
            } else {
                BotanyPots.LOGGER.error("Botany Pot at {} has invalid soil type {}. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
            }
        }
    }
}

