/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.crop;

import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.RecipeData;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class CropInfo
extends RecipeData {
    private final ResourceLocation id;
    private Ingredient seed;
    private Set<String> soilCategories;
    private int growthTicks;
    private float growthMultiplier;
    private List<HarvestEntry> results;
    private BlockState displayBlock;

    public CropInfo(ResourceLocation id, Ingredient seed, Set<String> soilCategories, int growthTicks, float growthMultiplier, List<HarvestEntry> results, BlockState displayState) {
        this.id = id;
        this.seed = seed;
        this.soilCategories = soilCategories;
        this.growthTicks = growthTicks;
        this.growthMultiplier = growthMultiplier;
        this.results = results;
        this.displayBlock = displayState;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public Ingredient getSeed() {
        return this.seed;
    }

    public Set<String> getSoilCategories() {
        return this.soilCategories;
    }

    public List<HarvestEntry> getResults() {
        return this.results;
    }

    public BlockState getDisplayState() {
        return this.displayBlock;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    public float getGrowthMultiplier() {
        return this.growthMultiplier;
    }

    public int getGrowthTicksForSoil(SoilInfo soil) {
        return MathHelper.func_76141_d((float)((float)soil.getTickRate() * this.getGrowthMultiplier() * (float)this.growthTicks));
    }

    public ItemStack getRandomSeed() {
        ItemStack[] matchingStacks = this.seed.func_193365_a();
        return matchingStacks.length > 0 ? matchingStacks[Bookshelf.RANDOM.nextInt(matchingStacks.length)] : ItemStack.field_190927_a;
    }

    public void setSeed(Ingredient seed) {
        this.seed = seed;
    }

    public void setSoilCategories(Set<String> soilCategories) {
        this.soilCategories = soilCategories;
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public void setGrowthMultiplier(float growthMultiplier) {
        this.growthMultiplier = growthMultiplier;
    }

    public void setResults(List<HarvestEntry> results) {
        this.results = results;
    }

    public void setDisplayBlock(BlockState displayBlock) {
        this.displayBlock = displayBlock;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return BotanyPots.instance.getContent().getRecipeSerializerCrop();
    }

    public IRecipeType<?> func_222127_g() {
        return BotanyPots.instance.getContent().getRecipeTypeCrop();
    }
}

