/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.soil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import net.darkhax.bookshelf.util.MCJsonUtils;
import net.darkhax.botanypots.PacketUtils;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoilSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<SoilInfo> {
    public static final SoilSerializer INSTANCE = new SoilSerializer();

    public SoilInfo read(ResourceLocation id, JsonObject json) {
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("input"));
        BlockState renderState = MCJsonUtils.deserializeBlockState((JsonObject)json.getAsJsonObject("display"));
        int tickRate = JSONUtils.func_151203_m((JsonObject)json, (String)"ticks");
        HashSet<String> categories = new HashSet<String>();
        for (JsonElement element : json.getAsJsonArray("categories")) {
            categories.add(element.getAsString().toLowerCase());
        }
        return new SoilInfo(id, input, renderState, tickRate, categories);
    }

    public SoilInfo read(ResourceLocation id, PacketBuffer buf) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buf);
        BlockState renderState = PacketUtils.deserializeBlockState(buf);
        int tickRate = buf.readInt();
        HashSet<String> categories = new HashSet<String>();
        PacketUtils.deserializeStringCollection(buf, categories);
        return new SoilInfo(id, ingredient, renderState, tickRate, categories);
    }

    public void write(PacketBuffer buffer, SoilInfo info) {
        info.getIngredient().func_199564_a(buffer);
        PacketUtils.serializeBlockState(buffer, info.getRenderState());
        buffer.writeInt(info.getTickRate());
        PacketUtils.serializeStringCollection(buffer, info.getCategories());
    }
}

