/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.crop;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.util.MCJsonUtils;
import net.darkhax.bookshelf.util.PacketUtils;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CropSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<CropInfo> {
    public static final CropSerializer INSTANCE = new CropSerializer();

    public CropInfo read(ResourceLocation id, JsonObject json) {
        Ingredient seed = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("seed"));
        Set<String> validSoils = CropSerializer.deserializeSoilInfo(id, json);
        int growthTicks = JSONUtils.func_151203_m((JsonObject)json, (String)"growthTicks");
        List<HarvestEntry> results = CropSerializer.deserializeCropEntries(id, json);
        JsonElement element = json.get("display");
        BlockState[] states = new BlockState[]{};
        if (element.isJsonObject()) {
            states = new BlockState[]{MCJsonUtils.deserializeBlockState((JsonObject)element.getAsJsonObject())};
        } else if (element.isJsonArray()) {
            ArrayList<BlockState> list = new ArrayList<BlockState>();
            for (JsonElement subElement : element.getAsJsonArray()) {
                if (!subElement.isJsonObject()) continue;
                list.add(MCJsonUtils.deserializeBlockState((JsonObject)subElement.getAsJsonObject()));
            }
            states = list.toArray(new BlockState[0]);
        }
        if (growthTicks <= 0) {
            throw new IllegalArgumentException("Crop " + id + " has an invalid growth tick rate. It must use a positive integer.");
        }
        return new CropInfo(id, seed, validSoils, growthTicks, results, states);
    }

    public CropInfo read(ResourceLocation id, PacketBuffer buf) {
        try {
            Ingredient seed = Ingredient.func_199566_b((PacketBuffer)buf);
            HashSet<String> validSoils = new HashSet<String>();
            PacketUtils.deserializeStringCollection((PacketBuffer)buf, validSoils);
            int growthTicks = buf.readInt();
            ArrayList<HarvestEntry> results = new ArrayList<HarvestEntry>();
            int length = buf.readInt();
            for (int i = 0; i < length; ++i) {
                results.add(HarvestEntry.deserialize(buf));
            }
            BlockState[] displayStates = new BlockState[buf.readInt()];
            for (int i = 0; i < displayStates.length; ++i) {
                displayStates[i] = PacketUtils.deserializeBlockState((PacketBuffer)buf);
            }
            return new CropInfo(id, seed, validSoils, growthTicks, results, displayStates);
        }
        catch (Exception e) {
            BotanyPots.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to read crop info from packet buffer. This is not good.");
        }
    }

    public void write(PacketBuffer buffer, CropInfo info) {
        try {
            info.getSeed().func_199564_a(buffer);
            PacketUtils.serializeStringCollection((PacketBuffer)buffer, info.getSoilCategories());
            buffer.writeInt(info.getGrowthTicks());
            buffer.writeInt(info.getResults().size());
            for (HarvestEntry entry : info.getResults()) {
                HarvestEntry.serialize(buffer, entry);
            }
            buffer.writeInt(info.getDisplayState().length);
            for (BlockState state : info.getDisplayState()) {
                PacketUtils.serializeBlockState((PacketBuffer)buffer, (BlockState)state);
            }
        }
        catch (Exception e) {
            BotanyPots.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to write crop to the packet buffer.");
        }
    }

    private static Set<String> deserializeSoilInfo(ResourceLocation ownerId, JsonObject json) {
        HashSet<String> categories = new HashSet<String>();
        for (JsonElement element : json.getAsJsonArray("categories")) {
            categories.add(element.getAsString().toLowerCase());
        }
        return categories;
    }

    private static List<HarvestEntry> deserializeCropEntries(ResourceLocation ownerId, JsonObject json) {
        ArrayList<HarvestEntry> crops = new ArrayList<HarvestEntry>();
        for (JsonElement entry : json.getAsJsonArray("results")) {
            if (!entry.isJsonObject()) {
                BotanyPots.LOGGER.error("Crop entry in {} is not a JsonObject.", (Object)ownerId);
                continue;
            }
            HarvestEntry cropEntry = HarvestEntry.deserialize(entry.getAsJsonObject());
            crops.add(cropEntry);
        }
        return crops;
    }
}

