/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.soil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import net.darkhax.bookshelf.util.MCJsonUtils;
import net.darkhax.bookshelf.util.PacketUtils;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoilSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<SoilInfo> {
    public static final SoilSerializer INSTANCE = new SoilSerializer();

    public SoilInfo read(ResourceLocation id, JsonObject json) {
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("input"));
        BlockState renderState = MCJsonUtils.deserializeBlockState((JsonObject)json.getAsJsonObject("display"));
        float growthModifier = JSONUtils.func_151217_k((JsonObject)json, (String)"growthModifier");
        HashSet<String> categories = new HashSet<String>();
        for (JsonElement element : json.getAsJsonArray("categories")) {
            categories.add(element.getAsString().toLowerCase());
        }
        if (growthModifier <= -1.0f) {
            throw new IllegalArgumentException("Soil " + id + " has an invalid growth modifier. It must be greater than -1.");
        }
        return new SoilInfo(id, input, renderState, growthModifier, categories);
    }

    public SoilInfo read(ResourceLocation id, PacketBuffer buf) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buf);
        BlockState renderState = PacketUtils.deserializeBlockState((PacketBuffer)buf);
        float growthModifier = buf.readFloat();
        HashSet<String> categories = new HashSet<String>();
        PacketUtils.deserializeStringCollection((PacketBuffer)buf, categories);
        return new SoilInfo(id, ingredient, renderState, growthModifier, categories);
    }

    public void write(PacketBuffer buffer, SoilInfo info) {
        info.getIngredient().func_199564_a(buffer);
        PacketUtils.serializeBlockState((PacketBuffer)buffer, (BlockState)info.getRenderState());
        buffer.writeFloat(info.getGrowthModifier());
        PacketUtils.serializeStringCollection((PacketBuffer)buffer, info.getCategories());
    }
}

