/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.bookshelf.util.RecipeUtils;
import net.darkhax.bookshelf.util.SidedExecutor;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.darkhax.botanypots.fertilizer.FertilizerInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BotanyPotHelper {
    public static RecipeManager getManager() {
        return BotanyPotHelper.getManager(null);
    }

    public static RecipeManager getManager(@Nullable RecipeManager manager) {
        return manager != null ? manager : (RecipeManager)SidedExecutor.callForSide(() -> () -> Minecraft.func_71410_x().field_71439_g.field_71174_a.func_199526_e(), () -> () -> ServerLifecycleHooks.getCurrentServer().func_199529_aN());
    }

    @Nullable
    public static Map<ResourceLocation, SoilInfo> getSoilData(RecipeManager manager) {
        if (manager != null) {
            return RecipeUtils.getRecipes(BotanyPots.instance.getContent().recipeTypeSoil, (RecipeManager)manager);
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static Map<ResourceLocation, CropInfo> getCropData(RecipeManager manager) {
        if (manager != null) {
            return RecipeUtils.getRecipes(BotanyPots.instance.getContent().recipeTypeCrop, (RecipeManager)manager);
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static Map<ResourceLocation, FertilizerInfo> getFertilizerData(RecipeManager manager) {
        if (manager != null) {
            return RecipeUtils.getRecipes(BotanyPots.instance.getContent().recipeTypeFertilizer, (RecipeManager)manager);
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static SoilInfo getSoil(ResourceLocation id) {
        RecipeManager manager = BotanyPotHelper.getManager();
        if (manager != null && id != null) {
            return (SoilInfo)((Object)RecipeUtils.getRecipes(BotanyPots.instance.getContent().recipeTypeSoil, (RecipeManager)manager).get(id));
        }
        return null;
    }

    @Nullable
    public static CropInfo getCrop(ResourceLocation id) {
        RecipeManager manager = BotanyPotHelper.getManager();
        if (manager != null && id != null) {
            return (CropInfo)((Object)RecipeUtils.getRecipes(BotanyPots.instance.getContent().recipeTypeCrop, (RecipeManager)manager).get(id));
        }
        return null;
    }

    @Nullable
    public static FertilizerInfo getFertilizer(ResourceLocation id) {
        RecipeManager manager = BotanyPotHelper.getManager();
        if (manager != null && id != null) {
            return (FertilizerInfo)((Object)RecipeUtils.getRecipes(BotanyPots.instance.getContent().recipeTypeFertilizer, (RecipeManager)manager).get(id));
        }
        return null;
    }

    public static int getRequiredGrowthTicks(@Nullable CropInfo crop, @Nullable SoilInfo soil) {
        return crop == null || soil == null ? -1 : crop.getGrowthTicksForSoil(soil);
    }

    @Nullable
    public static SoilInfo getSoilForItem(ItemStack item) {
        for (SoilInfo soilInfo : RecipeUtils.getRecipeList(BotanyPots.instance.getContent().recipeTypeSoil, (RecipeManager)BotanyPotHelper.getManager())) {
            if (!soilInfo.getIngredient().test(item)) continue;
            return soilInfo;
        }
        return null;
    }

    @Nullable
    public static CropInfo getCropForItem(ItemStack item) {
        for (CropInfo cropInfo : RecipeUtils.getRecipeList(BotanyPots.instance.getContent().recipeTypeCrop, (RecipeManager)BotanyPotHelper.getManager())) {
            if (!cropInfo.getSeed().test(item)) continue;
            return cropInfo;
        }
        return null;
    }

    @Nullable
    public static FertilizerInfo getFertilizerForItem(ItemStack item) {
        for (FertilizerInfo fertilizer : RecipeUtils.getRecipeList(BotanyPots.instance.getContent().recipeTypeFertilizer, (RecipeManager)BotanyPotHelper.getManager())) {
            if (!fertilizer.getIngredient().test(item)) continue;
            return fertilizer;
        }
        return null;
    }

    public static boolean isSoilValidForCrop(SoilInfo soil, CropInfo crop) {
        for (String soilCategory : soil.getCategories()) {
            for (String cropCategory : crop.getSoilCategories()) {
                if (!soilCategory.equalsIgnoreCase(cropCategory)) continue;
                return true;
            }
        }
        return false;
    }

    public static NonNullList<ItemStack> getHarvestStacks(World world, CropInfo crop) {
        NonNullList drops = NonNullList.func_191196_a();
        for (HarvestEntry cropEntry : crop.getResults()) {
            int rolls;
            if (!(world.field_73012_v.nextFloat() <= cropEntry.getChance()) || (rolls = MathsUtils.nextIntInclusive((Random)world.field_73012_v, (int)cropEntry.getMinRolls(), (int)cropEntry.getMaxRolls())) <= 0) continue;
            for (int roll = 0; roll < rolls; ++roll) {
                drops.add((Object)cropEntry.getItem().func_77946_l());
            }
        }
        return drops;
    }
}

