/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class RendererBotanyPot
extends TileEntityRenderer<TileEntityBotanyPot> {
    private static final Random RANDOM = new Random();
    private static final Direction[] SOIL_SIDES = new Direction[]{Direction.UP};
    private static final Direction[] CROP_SIDES = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private final boolean isOptifinePresent = RendererBotanyPot.detectOptifine();

    private static boolean detectOptifine() {
        try {
            Class<?> clazz = Class.forName("net.optifine.Config");
            return clazz != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RendererBotanyPot(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        if (this.isOptifinePresent) {
            BotanyPots.LOGGER.warn("Detected Optifine. Botany pots will be rendered in compatibility mode.");
        }
    }

    public void render(TileEntityBotanyPot tile, float partial, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        if (tile.getSoil() != null && BotanyPots.CLIENT_CONFIG.shouldRenderSoil()) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(0.625f, 0.384f, 0.625f);
            matrix.func_227861_a_(0.3, 0.01, 0.3);
            if (!this.isOptifinePresent) {
                this.renderBlock(tile.getSoil().getRenderState(), tile.func_145831_w(), tile.func_174877_v(), matrix, buffer, SOIL_SIDES);
            } else {
                this.renderBlock(tile.getSoil().getRenderState(), tile.func_145831_w(), tile.func_174877_v(), matrix, buffer);
            }
            matrix.func_227865_b_();
        }
        if (tile.getCrop() != null && BotanyPots.CLIENT_CONFIG.shouldRenderCrop()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, 0.4, 0.5);
            if (BotanyPots.CLIENT_CONFIG.shouldDoGrowthAnimation()) {
                float progressScale = 0.25f + ((float)tile.getCurrentGrowthTicks() + partial) / (float)tile.getTotalGrowthTicks() * 0.75f;
                float growth = MathHelper.func_76131_a((float)(progressScale * 0.625f), (float)0.0f, (float)1.0f);
                matrix.func_227862_a_(growth, growth, growth);
            }
            matrix.func_227861_a_(-0.5, 0.0, -0.5);
            BlockState[] cropStates = tile.getCrop().getDisplayState();
            for (int i = 0; i < cropStates.length; ++i) {
                matrix.func_227861_a_(0.0, (double)i, 0.0);
                if (!this.isOptifinePresent) {
                    this.renderBlock(cropStates[i], tile.func_145831_w(), tile.func_174877_v(), matrix, buffer, CROP_SIDES);
                } else {
                    this.renderBlock(cropStates[i], tile.func_145831_w(), tile.func_174877_v(), matrix, buffer);
                }
                matrix.func_227861_a_(0.0, (double)(-i), 0.0);
            }
            matrix.func_227865_b_();
        }
    }

    private void renderBlock(BlockState state, World world, BlockPos pos, MatrixStack matrix, IRenderTypeBuffer buffer, Direction[] renderSides) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(state);
        RenderType type = RenderUtils.findRenderType((BlockState)state);
        if (type != null) {
            ForgeHooksClient.setRenderLayer((RenderType)type);
            IVertexBuilder builder = buffer.getBuffer(type);
            RenderUtils.renderModel((BlockModelRenderer)dispatcher.func_175019_b(), (IBlockDisplayReader)world, (IBakedModel)model, (BlockState)state, (BlockPos)pos, (MatrixStack)matrix, (IVertexBuilder)builder, (Direction[])renderSides);
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    private void renderBlock(BlockState state, World world, BlockPos pos, MatrixStack matrix, IRenderTypeBuffer buffer) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(state);
        boolean useAO = Minecraft.func_71379_u() && state.getLightValue((IBlockReader)world, pos) == 0 && model.func_177555_b();
        RenderType type = RenderUtils.findRenderType((BlockState)state);
        if (type != null) {
            ForgeHooksClient.setRenderLayer((RenderType)type);
            IVertexBuilder builder = buffer.getBuffer(type);
            this.renderModel(dispatcher.func_175019_b(), useAO, (IBlockDisplayReader)world, model, state, pos, matrix, builder, false, OverlayTexture.field_229196_a_);
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    private boolean renderModel(BlockModelRenderer renderer, boolean useAO, IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack matrix, IVertexBuilder buffer, boolean checkSides, int overlay) {
        try {
            IModelData modelData = model.getModelData(world, pos, state, (IModelData)EmptyModelData.INSTANCE);
            return useAO ? renderer.renderModelSmooth(world, model, state, pos, matrix, buffer, checkSides, RANDOM, 0L, overlay, modelData) : renderer.renderModelFlat(world, model, state, pos, matrix, buffer, checkSides, RANDOM, 0L, overlay, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (BlockState)state);
            crashreportcategory.func_71507_a("Using AO", (Object)useAO);
            throw new ReportedException(crashreport);
        }
    }
}

