/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.tileentity;

import javax.annotation.Nullable;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.darkhax.bookshelf.util.InventoryUtils;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.network.BreakEffectsMessage;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityBotanyPot
extends TileEntityBasicTickable {
    @Nullable
    private SoilInfo soil;
    private ItemStack soilStack = ItemStack.field_190927_a;
    @Nullable
    private CropInfo crop;
    private ItemStack cropStack = ItemStack.field_190927_a;
    private int totalGrowthTicks;
    private int currentGrowthTicks;
    private int autoHarvestCooldown;
    private ChunkPos chunkPos;

    public TileEntityBotanyPot() {
        super(BotanyPots.instance.getContent().tileBotanyPot);
    }

    public boolean canSetSoil(@Nullable SoilInfo newSoil) {
        return newSoil == null || this.getSoil() == null;
    }

    public void setSoil(@Nullable SoilInfo newSoil, ItemStack stack) {
        this.soil = newSoil;
        this.soilStack = stack;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void sync() {
        if (this.field_145850_b instanceof ServerWorld) {
            SUpdateTileEntityPacket packet = this.func_189518_D_();
            TileEntityBotanyPot.sendToTracking((ServerWorld)this.field_145850_b, this.getChunkPos(), this.field_174879_c, packet, false);
        }
    }

    public boolean canSetCrop(@Nullable CropInfo newCrop) {
        return newCrop == null || this.getSoil() != null && this.getCrop() == null;
    }

    public void setCrop(@Nullable CropInfo newCrop, ItemStack stack) {
        this.crop = newCrop;
        this.cropStack = stack;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    @Nullable
    public SoilInfo getSoil() {
        return this.soil;
    }

    @Nullable
    public CropInfo getCrop() {
        return this.crop;
    }

    public int getTotalGrowthTicks() {
        return this.totalGrowthTicks;
    }

    public int getCurrentGrowthTicks() {
        return this.currentGrowthTicks;
    }

    public boolean canHarvest() {
        return this.crop != null && this.getTotalGrowthTicks() > 0 && this.getCurrentGrowthTicks() >= this.getTotalGrowthTicks();
    }

    public void resetGrowthTime() {
        this.totalGrowthTicks = BotanyPotHelper.getRequiredGrowthTicks(this.getCrop(), this.getSoil());
        this.currentGrowthTicks = 0;
        if (this.soil != null) {
            this.soil = BotanyPotHelper.getSoil(this.soil.func_199560_c());
            if (this.soil == null) {
                this.crop = null;
            }
        }
        if (this.crop != null) {
            this.crop = BotanyPotHelper.getCrop(this.crop.func_199560_c());
        }
        this.autoHarvestCooldown = 2;
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.getState().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void addGrowth(int ticksToGrow) {
        this.currentGrowthTicks += ticksToGrow;
        if (this.currentGrowthTicks > this.totalGrowthTicks) {
            this.currentGrowthTicks = this.totalGrowthTicks;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public float getGrowthPercent() {
        if (this.totalGrowthTicks == -1 || this.currentGrowthTicks == -1) {
            return 0.0f;
        }
        return (float)this.currentGrowthTicks / (float)this.totalGrowthTicks;
    }

    public void onTileTick() {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        if (this.hasSoilAndCrop()) {
            if (this.isDoneGrowing()) {
                BlockState state = this.getState();
                if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
                }
                this.attemptAutoHarvest();
            } else {
                ++this.currentGrowthTicks;
            }
        } else if (this.totalGrowthTicks != -1 || this.currentGrowthTicks != 0) {
            this.resetGrowthTime();
        }
    }

    public boolean hasSoilAndCrop() {
        return this.soil != null && this.crop != null;
    }

    public boolean isDoneGrowing() {
        return this.hasSoilAndCrop() && this.totalGrowthTicks > 0 && this.currentGrowthTicks >= this.totalGrowthTicks;
    }

    private void attemptAutoHarvest() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockBotanyPot && ((BlockBotanyPot)block).isHopper()) {
            if (this.autoHarvestCooldown > 0) {
                --this.autoHarvestCooldown;
                return;
            }
            IItemHandler inventory = InventoryUtils.getInventory((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP);
            if (inventory != EmptyHandler.INSTANCE && !this.field_145850_b.field_72995_K) {
                boolean didAutoHarvest = false;
                block0: for (ItemStack item : BotanyPotHelper.getHarvestStacks(this.field_145850_b, this.getCrop())) {
                    for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                        if (!inventory.isItemValid(slot, item) || inventory.insertItem(slot, item, true).func_190916_E() == item.func_190916_E()) continue;
                        inventory.insertItem(slot, item, false);
                        didAutoHarvest = true;
                        continue block0;
                    }
                }
                if (didAutoHarvest) {
                    this.onCropHarvest();
                    this.resetGrowthTime();
                }
            }
        }
    }

    public void onCropHarvest() {
        IChunk chunk;
        if (this.hasSoilAndCrop() && (chunk = this.field_145850_b.func_217349_x(this.field_174879_c)) instanceof Chunk) {
            BotanyPots.NETWORK.sendToChunk((Chunk)chunk, (Object)new BreakEffectsMessage(this.field_174879_c, this.crop.getDisplayState()[0]));
        }
    }

    public void serialize(CompoundNBT dataTag) {
        if (this.soil != null) {
            dataTag.func_74778_a("Soil", this.soil.func_199560_c().toString());
            if (this.crop != null) {
                dataTag.func_74778_a("Crop", this.crop.func_199560_c().toString());
                dataTag.func_74768_a("GrowthTicks", this.currentGrowthTicks);
            }
        }
        dataTag.func_218657_a("CropStack", (INBT)this.cropStack.serializeNBT());
        dataTag.func_218657_a("SoilStack", (INBT)this.soilStack.serializeNBT());
    }

    public void deserialize(CompoundNBT dataTag) {
        this.soil = null;
        this.crop = null;
        if (dataTag.func_74764_b("CropStack")) {
            this.cropStack = ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("CropStack"));
        }
        if (dataTag.func_74764_b("SoilStack")) {
            this.soilStack = ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("SoilStack"));
        }
        if (dataTag.func_74764_b("Soil")) {
            String rawSoilId = dataTag.func_74779_i("Soil");
            ResourceLocation soilId = ResourceLocation.func_208304_a((String)rawSoilId);
            if (soilId != null) {
                SoilInfo foundSoil = BotanyPotHelper.getSoil(soilId);
                if (foundSoil != null) {
                    this.soil = foundSoil;
                    if (dataTag.func_74764_b("Crop")) {
                        String rawCropId = dataTag.func_74779_i("Crop");
                        ResourceLocation cropId = ResourceLocation.func_208304_a((String)rawCropId);
                        if (cropId != null) {
                            CropInfo cropInfo = BotanyPotHelper.getCrop(cropId);
                            if (cropInfo != null) {
                                this.crop = cropInfo;
                                this.currentGrowthTicks = dataTag.func_74762_e("GrowthTicks");
                                this.totalGrowthTicks = this.crop.getGrowthTicksForSoil(this.soil);
                            } else {
                                BotanyPots.LOGGER.error("Botany Pot at {} had a crop of type {} but that crop does not exist. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                            }
                        } else {
                            BotanyPots.LOGGER.error("Botany Pot at {} has an invalid crop Id of {}. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                        }
                    }
                } else {
                    BotanyPots.LOGGER.error("Botany Pot at {} had a soil of type {} which no longer exists. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
                }
            } else {
                BotanyPots.LOGGER.error("Botany Pot at {} has invalid soil type {}. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
            }
        }
    }

    public ItemStack getSoilStack() {
        return this.soilStack;
    }

    public ItemStack getCropStack() {
        return this.cropStack;
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.field_174879_c);
        }
        return this.chunkPos;
    }

    public static void sendToTracking(ServerWorld world, ChunkPos chunkPos, BlockPos blockPos, IPacket<?> packet, boolean boundaryOnly) {
        world.func_72863_F().field_217237_a.func_219097_a(chunkPos, boundaryOnly).forEach(p -> p.field_71135_a.func_147359_a(packet));
    }
}

