/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.crop;

import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.crafting.RecipeDataBase;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class CropInfo
extends RecipeDataBase {
    private Ingredient seed;
    private Set<String> soilCategories;
    private int growthTicks;
    private List<HarvestEntry> results;
    private BlockState[] displayBlocks;

    public CropInfo(ResourceLocation id, Ingredient seed, Set<String> soilCategories, int growthTicks, List<HarvestEntry> results, BlockState[] displayStates) {
        super(id);
        this.seed = seed;
        this.soilCategories = soilCategories;
        this.growthTicks = growthTicks;
        this.results = results;
        this.displayBlocks = displayStates;
    }

    public Ingredient getSeed() {
        return this.seed;
    }

    public Set<String> getSoilCategories() {
        return this.soilCategories;
    }

    public List<HarvestEntry> getResults() {
        return this.results;
    }

    public BlockState[] getDisplayState() {
        return this.displayBlocks;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    public int getGrowthTicksForSoil(SoilInfo soil) {
        float requiredGrowthTicks = this.growthTicks;
        float growthModifier = soil.getGrowthModifier();
        if (growthModifier > -1.0f) {
            return MathHelper.func_76141_d((float)(requiredGrowthTicks * (1.0f + growthModifier * -1.0f)));
        }
        return -1;
    }

    public void setSeed(Ingredient seed) {
        this.seed = seed;
    }

    public void setSoilCategories(Set<String> soilCategories) {
        this.soilCategories = soilCategories;
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public void setResults(List<HarvestEntry> results) {
        this.results = results;
    }

    public void setDisplayBlock(BlockState[] displayBlocks) {
        this.displayBlocks = displayBlocks;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return BotanyPots.instance.getContent().recipeSerializerCrop;
    }

    public IRecipeType<?> func_222127_g() {
        return BotanyPots.instance.getContent().recipeTypeCrop;
    }

    public ITextComponent getName() {
        return this.getDisplayState()[0].func_177230_c().func_235333_g_();
    }
}

