/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.data.bounty;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import ejektaflex.bountiful.data.bounty.BountyEntry;
import ejektaflex.bountiful.data.bounty.BountyProgress;
import ejektaflex.bountiful.data.bounty.IBountyObjective;
import ejektaflex.bountiful.data.bounty.enums.BountyType;
import ejektaflex.bountiful.ext.ExtStringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0017H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lejektaflex/bountiful/data/bounty/BountyEntryEntity;", "Lejektaflex/bountiful/data/bounty/BountyEntry;", "Lejektaflex/bountiful/data/bounty/IBountyObjective;", "()V", "bType", "", "getBType", "()Ljava/lang/String;", "setBType", "(Ljava/lang/String;)V", "calculatedWorth", "", "getCalculatedWorth", "()I", "formattedName", "Lnet/minecraft/util/text/ITextComponent;", "getFormattedName", "()Lnet/minecraft/util/text/ITextComponent;", "killedAmount", "getKilledAmount", "setKilledAmount", "(I)V", "deserializeNBT", "", "tag", "Lnet/minecraft/nbt/CompoundNBT;", "isSameEntity", "", "e", "Lnet/minecraft/entity/LivingEntity;", "serializeNBT", "toString", "tooltipObjective", "progress", "Lejektaflex/bountiful/data/bounty/BountyProgress;", "validate", "Bountiful"})
public final class BountyEntryEntity
extends BountyEntry
implements IBountyObjective {
    @Expose
    @SerializedName(value="type")
    @NotNull
    private String bType = BountyType.Entity.getId();
    private int killedAmount;

    @Override
    @NotNull
    public String getBType() {
        return this.bType;
    }

    @Override
    public void setBType(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.bType = string;
    }

    public final int getKilledAmount() {
        return this.killedAmount;
    }

    public final void setKilledAmount(int n) {
        this.killedAmount = n;
    }

    @Override
    public int getCalculatedWorth() {
        return this.getUnitWorth() * this.getAmount();
    }

    @Override
    public void validate() {
    }

    @Override
    public void deserializeNBT(@NotNull CompoundNBT tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.deserializeNBT(tag);
        this.killedAmount = tag.func_74762_e("killedAmount");
    }

    @Override
    @NotNull
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = super.serializeNBT();
        boolean bl = false;
        boolean bl2 = false;
        CompoundNBT $this$apply = compoundNBT;
        boolean bl3 = false;
        $this$apply.func_74768_a("killedAmount", this.killedAmount);
        return compoundNBT;
    }

    public final boolean isSameEntity(@NotNull LivingEntity e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        EntityType entityType = e.func_200600_R();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityType, (String)"e.type");
        ResourceLocation ereg = entityType.getRegistryName();
        return Intrinsics.areEqual((Object)String.valueOf(ereg), (Object)this.getContent());
    }

    @Override
    @NotNull
    public ITextComponent getFormattedName() {
        ITextComponent iTextComponent = ExtStringKt.getToEntityType(this.getContent());
        if (iTextComponent == null || (iTextComponent = iTextComponent.func_212546_e()) == null) {
            iTextComponent = (ITextComponent)new StringTextComponent(this.getContent());
        }
        return iTextComponent;
    }

    @Override
    @NotNull
    public ITextComponent tooltipObjective(@NotNull BountyProgress progress) {
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        ITextComponent iTextComponent = new StringTextComponent("").func_150257_a(this.getFormattedName().func_211708_a(progress.getColor())).func_150257_a((ITextComponent)new StringTextComponent(" ")).func_150257_a(new TranslationTextComponent("bountiful.bounty.type.entity.kills", new Object[0]).func_211708_a(progress.getColor())).func_150257_a((ITextComponent)new StringTextComponent(" ")).func_150257_a(new StringTextComponent(progress.getStringNums()).func_211708_a(TextFormatting.WHITE));
        Intrinsics.checkExpressionValueIsNotNull((Object)iTextComponent, (String)"StringTextComponent(\"\").\u2026rmatting.WHITE)\n        )");
        return iTextComponent;
    }

    @NotNull
    public String toString() {
        return "BountyEntry (" + this.getBType() + ") [Entity: " + this.getContent() + ", Amount: " + this.getAmount() + ", Weight: " + this.getWeight() + ']';
    }
}

