/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.item;

import ejektaflex.bountiful.BountifulConfig;
import ejektaflex.bountiful.BountifulContent;
import ejektaflex.bountiful.data.bounty.BountyData;
import ejektaflex.bountiful.data.bounty.checkers.CheckerRegistry;
import ejektaflex.bountiful.data.bounty.enums.BountyNBT;
import ejektaflex.bountiful.data.bounty.enums.BountyRarity;
import ejektaflex.bountiful.data.registry.DecreeRegistry;
import ejektaflex.bountiful.data.structure.Decree;
import ejektaflex.bountiful.ext.ExtMiscKt;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 02\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J0\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010H\u0016J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070(2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0014H\u0016J \u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0010H\u0016\u00a8\u00061"}, d2={"Lejektaflex/bountiful/item/ItemBounty;", "Lnet/minecraft/item/Item;", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "cashIn", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "ensureBounty", "decrees", "", "Lejektaflex/bountiful/data/structure/Decree;", "rarity", "Lejektaflex/bountiful/data/bounty/enums/BountyRarity;", "ensureTimerStarted", "getDisplayName", "getRarity", "Lnet/minecraft/item/Rarity;", "getTranslationKey", "", "inventoryTick", "entityIn", "Lnet/minecraft/entity/Entity;", "itemSlot", "", "isSelected", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "playerIn", "handIn", "shouldCauseReequipAnimation", "oldStack", "newStack", "slotChanged", "BountyCreationException", "Companion", "Bountiful"})
public final class ItemBounty
extends Item
implements IForgeRegistryEntry<Item> {
    private static final Random rand;
    public static final Companion Companion;

    @NotNull
    public String func_77658_a() {
        return "bountiful.bounty";
    }

    @NotNull
    public ITextComponent func_200295_i(@NotNull ItemStack stack) {
        ITextComponent iTextComponent;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (BountyData.Companion.isValidBounty(stack)) {
            ItemStack $this$toData$iv = stack;
            boolean $i$f$toData = false;
            boolean bl = false;
            BountyData bountyData = new BountyData();
            boolean bl2 = false;
            boolean bl3 = false;
            INBTSerializable $this$apply$iv = bountyData;
            boolean bl4 = false;
            ItemStack itemStack = $this$toData$iv.getStack();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            $this$apply$iv.deserializeNBT((INBT)itemStack.func_77978_p());
            BountyData bd = (BountyData)((INBTSerializable)bountyData);
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("bountiful.rarity." + bd.getRarityEnum().name(), new Object[0]);
            boolean bl5 = false;
            boolean bl6 = false;
            TranslationTextComponent $this$apply = translationTextComponent;
            boolean bl7 = false;
            $this$apply.func_150257_a((ITextComponent)new StringTextComponent(" "));
            $this$apply.func_150257_a(super.func_200295_i(stack));
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
                if (clientWorld != null) {
                    ClientWorld clientWorld2 = clientWorld;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    ClientWorld world = clientWorld2;
                    boolean bl10 = false;
                    $this$apply.func_150257_a((ITextComponent)new StringTextComponent(" \u00a7f(" + bd.remainingTime((World)world) + "\u00a7f)"));
                }
            }
            iTextComponent = (ITextComponent)translationTextComponent;
        } else {
            ITextComponent iTextComponent2 = super.func_200295_i(stack);
            iTextComponent = iTextComponent2;
            Intrinsics.checkExpressionValueIsNotNull((Object)iTextComponent2, (String)"super.getDisplayName(stack)");
        }
        return iTextComponent;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull PlayerEntity playerIn, @NotNull Hand handIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        if (worldIn.field_72995_K) {
            ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
            Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
            return actionResult;
        }
        if (!((Boolean)BountifulConfig.Companion.getSERVER().getCashInAtBountyBoard().get()).booleanValue()) {
            this.cashIn(playerIn, handIn);
        } else {
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("bountiful.bounty.turnin", new Object[0]));
        }
        ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
        return actionResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        if (stack.func_77942_o()) {
            ItemStack $this$toData$iv = stack;
            boolean $i$f$toData = false;
            boolean bl = false;
            BountyData bountyData = new BountyData();
            boolean bl2 = false;
            boolean bl3 = false;
            INBTSerializable $this$apply$iv = bountyData;
            boolean bl4 = false;
            ItemStack itemStack = $this$toData$iv.getStack();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            $this$apply$iv.deserializeNBT((INBT)itemStack.func_77978_p());
            BountyData bounty = (BountyData)((INBTSerializable)bountyData);
            World world = worldIn;
            if (world == null) {
                Intrinsics.throwNpe();
            }
            List<ITextComponent> bountyTipInfo = bounty.tooltipInfo(world, false);
            for (ITextComponent line : bountyTipInfo) {
                tooltip.add(line);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rarity func_77613_e(@NotNull ItemStack stack) {
        Rarity rarity;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_77942_o()) {
            CompoundNBT compoundNBT = stack.func_77978_p();
            if (compoundNBT == null) {
                Intrinsics.throwNpe();
            }
            if (compoundNBT.func_74764_b(BountyNBT.Rarity.getKey())) {
                CompoundNBT compoundNBT2 = stack.func_77978_p();
                if (compoundNBT2 == null) {
                    Intrinsics.throwNpe();
                }
                rarity = BountyRarity.Companion.getRarityFromInt(compoundNBT2.func_74762_e(BountyNBT.Rarity.getKey())).getItemRarity();
                return rarity;
            }
        }
        Rarity rarity2 = super.func_77613_e(stack);
        rarity = rarity2;
        Intrinsics.checkExpressionValueIsNotNull((Object)rarity2, (String)"super.getRarity(stack)");
        return rarity;
    }

    public final void ensureTimerStarted(@NotNull ItemStack stack, @NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        if (stack.func_77973_b() instanceof ItemBounty && stack.func_77942_o()) {
            CompoundNBT compoundNBT = stack.func_77978_p();
            if (compoundNBT == null) {
                Intrinsics.throwNpe();
            }
            if (!compoundNBT.func_74764_b(BountyNBT.BountyStamp.getKey())) {
                CompoundNBT compoundNBT2 = stack.func_77978_p();
                if (compoundNBT2 == null) {
                    Intrinsics.throwNpe();
                }
                compoundNBT2.func_74772_a(BountyNBT.BountyStamp.getKey(), worldIn.func_82737_E());
            }
        }
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 20L == 3L) {
            this.ensureTimerStarted(stack, worldIn);
        }
    }

    public final void ensureBounty(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull List<Decree> decrees, @NotNull BountyRarity rarity) {
        BountyData bountyData;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull(decrees, (String)"decrees");
        Intrinsics.checkParameterIsNotNull((Object)((Object)rarity), (String)"rarity");
        try {
            bountyData = BountyData.Companion.create(rarity, decrees);
        }
        catch (BountyCreationException e) {
            return;
        }
        BountyData data = bountyData;
        if (stack.func_77973_b() instanceof ItemBounty) {
            if (!stack.func_77942_o()) {
                bountyData = data.serializeNBT();
                ItemStack itemStack = stack;
                boolean bl = false;
                boolean bl2 = false;
                BountyData $this$apply = bountyData;
                boolean bl3 = false;
                $this$apply.func_82580_o(BountyNBT.BountyStamp.getKey());
                $this$apply.func_74772_a(BountyNBT.BoardStamp.getKey(), worldIn.func_82737_E());
                BountyData bountyData2 = bountyData;
                itemStack.func_77982_d((CompoundNBT)bountyData2);
            }
        } else {
            throw (Throwable)new Exception(stack.func_200301_q() + " is not an ItemBounty, so you cannot generate bounty data for it!");
        }
    }

    public final boolean cashIn(@NotNull PlayerEntity player, @NotNull Hand hand2) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand2, (String)"hand");
        ItemStack bountyItem = player.func_184586_b(hand2);
        if (!bountyItem.func_77942_o()) {
            ItemStack itemStack = player.func_184586_b(hand2);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"player.getHeldItem(hand)");
            World world = player.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
            this.ensureBounty(itemStack, world, DecreeRegistry.INSTANCE.getContent(), Companion.calcRarity());
            return false;
        }
        ItemStack itemStack = bountyItem;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"bountyItem");
        ItemStack $this$toData$iv = itemStack;
        boolean $i$f$toData = false;
        boolean bl = false;
        BountyData bountyData = new BountyData();
        boolean bl2 = false;
        boolean bl3 = false;
        INBTSerializable $this$apply$iv = bountyData;
        boolean bl4 = false;
        ItemStack itemStack2 = $this$toData$iv.getStack();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"stack");
        $this$apply$iv.deserializeNBT((INBT)itemStack2.func_77978_p());
        BountyData bounty = (BountyData)((INBTSerializable)bountyData);
        World world = player.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
        if (bounty.hasExpired(world)) {
            ExtMiscKt.sendTranslation((Entity)player, "bountiful.bounty.expired");
            return false;
        }
        boolean succ = CheckerRegistry.INSTANCE.tryCashIn(player, bounty);
        if (succ) {
            bountyItem.func_190918_g(bountyItem.func_77976_d());
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        Intrinsics.checkParameterIsNotNull((Object)oldStack, (String)"oldStack");
        Intrinsics.checkParameterIsNotNull((Object)newStack, (String)"newStack");
        return slotChanged;
    }

    public ItemBounty() {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)BountifulContent.BountifulGroup.INSTANCE));
        this.func_185043_a(new ResourceLocation("bountiful", "rarity"), 1.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        rand = new Random();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lejektaflex/bountiful/item/ItemBounty$BountyCreationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "err", "", "(Ljava/lang/String;)V", "Bountiful"})
    public static final class BountyCreationException
    extends Exception {
        public BountyCreationException(@NotNull String err) {
            Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
            super(err);
        }

        public /* synthetic */ BountyCreationException(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "Bounty could not be created!";
            }
            this(string);
        }

        public BountyCreationException() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lejektaflex/bountiful/item/ItemBounty$Companion;", "", "()V", "rand", "Ljava/util/Random;", "calcRarity", "Lejektaflex/bountiful/data/bounty/enums/BountyRarity;", "create", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "decrees", "", "Lejektaflex/bountiful/data/structure/Decree;", "Bountiful"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BountyRarity calcRarity() {
            int level = 0;
            Double chance = (Double)BountifulConfig.Companion.getSERVER().getRarityChance().get();
            int n = 0;
            int n2 = 3;
            while (n < n2) {
                void i;
                double d = rand.nextFloat();
                Double d2 = chance;
                Intrinsics.checkExpressionValueIsNotNull((Object)d2, (String)"chance");
                if (Double.compare(d, d2) >= 0) break;
                ++level;
                ++i;
            }
            return BountyRarity.Companion.getRarityFromInt(level);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ItemStack create(@NotNull World world, @NotNull List<Decree> decrees) {
            void it;
            Item item;
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull(decrees, (String)"decrees");
            ItemStack itemStack = new ItemStack((IItemProvider)BountifulContent.Items.INSTANCE.getBOUNTY());
            boolean bl = false;
            boolean bl2 = false;
            ItemStack $this$apply = itemStack;
            boolean bl3 = false;
            ItemStack $this$edit$iv = $this$apply;
            boolean $i$f$edit = false;
            if ($this$edit$iv.func_77973_b() instanceof ItemBounty) {
                item = $this$edit$iv.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ejektaflex.bountiful.item.ItemBounty");
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Tried to edit stack ");
                ItemStack itemStack2 = $this$edit$iv.getStack();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"stack");
                StringBuilder stringBuilder2 = stringBuilder.append(itemStack2.func_190916_E()).append("x ");
                ItemStack itemStack3 = $this$edit$iv.getStack();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"stack");
                Item item2 = itemStack3.func_77973_b();
                Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"stack.item");
                throw (Throwable)new Exception(stringBuilder2.append(item2.getRegistryName()).append(" as if it was a ").append(Reflection.getOrCreateKotlinClass(ItemBounty.class)).toString());
            }
            ItemStack itemStack4 = $this$edit$iv;
            ItemBounty $this$edit = (ItemBounty)item;
            boolean bl4 = false;
            $this$edit.ensureBounty((ItemStack)it, world, decrees, Companion.calcRarity());
            return itemStack;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

