/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.data.bounty;

import ejektaflex.bountiful.BountifulConfig;
import ejektaflex.bountiful.data.bounty.BountyData;
import ejektaflex.bountiful.data.bounty.BountyEntry;
import ejektaflex.bountiful.data.bounty.BountyProgress;
import ejektaflex.bountiful.data.bounty.IBountyObjective;
import ejektaflex.bountiful.data.bounty.IBountyReward;
import ejektaflex.bountiful.data.bounty.checkers.CheckerRegistry;
import ejektaflex.bountiful.data.bounty.enums.BountyNBT;
import ejektaflex.bountiful.data.bounty.enums.BountyRarity;
import ejektaflex.bountiful.data.bounty.enums.BountyType;
import ejektaflex.bountiful.data.registry.DecreeRegistry;
import ejektaflex.bountiful.data.structure.Decree;
import ejektaflex.bountiful.ext.ExtMiscKt;
import ejektaflex.bountiful.ext.ExtNBTKt;
import ejektaflex.bountiful.util.ValueRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 >2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u001e\u0010+\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\u000e\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u0002H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000bH\u0002J\u0010\u00104\u001a\u0002022\u0006\u00103\u001a\u00020\u000bH\u0002J\u000e\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020.J\u000e\u00107\u001a\u0002022\u0006\u0010-\u001a\u00020.J\b\u00108\u001a\u00020\u0002H\u0016J\u000e\u00109\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.J\u000e\u0010:\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.J\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020<0(2\u0006\u0010-\u001a\u00020.2\u0006\u0010=\u001a\u000206R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0007\"\u0004\b\u001d\u0010\tR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001a\u00a8\u0006?"}, d2={"Lejektaflex/bountiful/data/bounty/BountyData;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/CompoundNBT;", "()V", "boardStamp", "", "getBoardStamp", "()I", "setBoardStamp", "(I)V", "bountyStamp", "", "getBountyStamp", "()Ljava/lang/Long;", "setBountyStamp", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "bountyTime", "getBountyTime", "()J", "setBountyTime", "(J)V", "objectives", "Lejektaflex/bountiful/util/ValueRegistry;", "Lejektaflex/bountiful/data/bounty/BountyEntry;", "getObjectives", "()Lejektaflex/bountiful/util/ValueRegistry;", "rarity", "getRarity", "setRarity", "rarityEnum", "Lejektaflex/bountiful/data/bounty/enums/BountyRarity;", "getRarityEnum", "()Lejektaflex/bountiful/data/bounty/enums/BountyRarity;", "rewards", "getRewards", "assignObjectives", "", "inRarity", "decrees", "", "Lejektaflex/bountiful/data/structure/Decree;", "worth", "assignRewards", "boardTimeLeft", "world", "Lnet/minecraft/world/World;", "deserializeNBT", "tag", "formatTickTime", "", "n", "formatTimeExpirable", "hasExpired", "", "remainingTime", "serializeNBT", "timeLeft", "timeTaken", "tooltipInfo", "Lnet/minecraft/util/text/ITextComponent;", "advanced", "Companion", "Bountiful"})
public final class BountyData
implements INBTSerializable<CompoundNBT> {
    private int boardStamp = Companion.getMaxTimeAtBoard();
    private long bountyTime;
    private int rarity;
    @NotNull
    private final ValueRegistry<BountyEntry> objectives = new ValueRegistry();
    @NotNull
    private final ValueRegistry<BountyEntry> rewards = new ValueRegistry();
    @Nullable
    private Long bountyStamp;
    private static final Random rando;
    public static final long bountyTickFreq = 20L;
    public static final long boardTickFreq = 20L;
    public static final Companion Companion;

    public final int getBoardStamp() {
        return this.boardStamp;
    }

    public final void setBoardStamp(int n) {
        this.boardStamp = n;
    }

    public final long getBountyTime() {
        return this.bountyTime;
    }

    public final void setBountyTime(long l) {
        this.bountyTime = l;
    }

    public final int getRarity() {
        return this.rarity;
    }

    public final void setRarity(int n) {
        this.rarity = n;
    }

    @NotNull
    public final ValueRegistry<BountyEntry> getObjectives() {
        return this.objectives;
    }

    @NotNull
    public final ValueRegistry<BountyEntry> getRewards() {
        return this.rewards;
    }

    @Nullable
    public final Long getBountyStamp() {
        return this.bountyStamp;
    }

    public final void setBountyStamp(@Nullable Long l) {
        this.bountyStamp = l;
    }

    public final long timeTaken(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Long l = this.bountyStamp;
        return world.func_82737_E() - (l != null ? l.longValue() : world.func_82737_E());
    }

    public final long timeLeft(@NotNull World world) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        if (this.bountyStamp == null) {
            l = this.bountyTime;
        } else {
            Long l2 = this.bountyStamp;
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            long l3 = l2 + this.bountyTime - world.func_82737_E();
            long l4 = 0L;
            boolean bl = false;
            l = Math.max(l3, l4);
        }
        return l;
    }

    public final boolean hasExpired(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        return this.timeLeft(world) <= 0L;
    }

    @NotNull
    public final BountyRarity getRarityEnum() {
        return BountyRarity.Companion.getRarityFromInt(this.rarity);
    }

    public final long boardTimeLeft(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        long l = (long)(this.boardStamp + Companion.getMaxTimeAtBoard()) - world.func_82737_E();
        long l2 = 0L;
        boolean bl = false;
        return Math.max(l, l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ITextComponent> tooltipInfo(@NotNull World world, boolean advanced) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayerEntity == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)clientPlayerEntity, (String)"Minecraft.getInstance().player!!");
        Map<BountyEntry, BountyProgress> passed = CheckerRegistry.INSTANCE.passedChecks((PlayerEntity)clientPlayerEntity, this);
        BountyType[] $this$map$iv = BountyType.values();
        boolean $i$f$map = false;
        BountyType[] bountyTypeArray = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it;
            void var14_25 = item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getId();
            collection.add(object);
        }
        List typeIds = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = MapsKt.toList(passed);
        boolean $i$f$sortedBy = false;
        destination$iv$iv = $this$sortedBy$iv;
        $i$f$mapTo = false;
        Comparator comparator = new Comparator<T>(typeIds){
            final /* synthetic */ List $typeIds$inlined;
            {
                this.$typeIds$inlined = list;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(this.$typeIds$inlined.indexOf(((BountyEntry)it.getFirst()).getBType()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = this.$typeIds$inlined.indexOf(((BountyEntry)it.getFirst()).getBType());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        Iterable $this$map$iv2 = CollectionsKt.sortedWith((Iterable)destination$iv$iv, (Comparator)comparator);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Object object2 = it.getFirst();
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ejektaflex.bountiful.data.bounty.IBountyObjective");
            }
            object = ((IBountyObjective)object2).tooltipObjective((BountyProgress)it.getSecond());
            collection.add(object);
        }
        List objs = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = this.rewards.getContent();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            BountyEntry bl = (BountyEntry)item$iv$iv2;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            void v2 = it;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ejektaflex.bountiful.data.bounty.IBountyReward");
            }
            object = ((IBountyReward)v2).tooltipReward();
            collection.add(object);
        }
        List rews = (List)destination$iv$iv3;
        collection = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new TranslationTextComponent("bountiful.tooltip.required", new Object[0]).func_211710_a((Consumer)tooltipInfo.1.INSTANCE)), (Iterable)objs), (Iterable)CollectionsKt.listOf((Object)new TranslationTextComponent("bountiful.tooltip.rewards", new Object[0]).func_211710_a((Consumer)tooltipInfo.2.INSTANCE))), (Iterable)rews);
        boolean bl = false;
        object = CollectionsKt.emptyList();
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object))));
    }

    @NotNull
    public final String remainingTime(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        return this.formatTimeExpirable(this.timeLeft(world) / 20L);
    }

    private final String formatTickTime(long n) {
        return n / (long)60 <= 0L ? "" + n + 's' : n / (long)60 + "m " + n % (long)60 + 's';
    }

    private final String formatTimeExpirable(long n) {
        return n <= 0L ? "\u00a74" + I18n.func_135052_a((String)"bountiful.tooltip.expired", (Object[])new Object[0]) : this.formatTickTime(n);
    }

    public void deserializeNBT(@NotNull CompoundNBT tag) {
        BountyEntry bountyEntry;
        CompoundNBT it;
        Collection<BountyEntry> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.boardStamp = tag.func_74762_e(BountyNBT.BoardStamp.getKey());
        this.bountyTime = tag.func_74763_f(BountyNBT.BountyTime.getKey());
        this.rarity = tag.func_74762_e(BountyNBT.Rarity.getKey());
        if (tag.func_74764_b(BountyNBT.BountyStamp.getKey())) {
            this.bountyStamp = tag.func_74763_f(BountyNBT.BountyStamp.getKey());
        }
        Iterable iterable = ExtNBTKt.getUnsortedList(tag, BountyNBT.Objectives.getKey());
        ValueRegistry<BountyEntry> valueRegistry = this.objectives;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CompoundNBT compoundNBT = (CompoundNBT)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            bountyEntry = ExtNBTKt.getToBountyEntry(it);
            collection.add(bountyEntry);
        }
        collection = (List)destination$iv$iv;
        valueRegistry.restore((List<BountyEntry>)collection);
        $this$map$iv = ExtNBTKt.getUnsortedList(tag, BountyNBT.Rewards.getKey());
        valueRegistry = this.rewards;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CompoundNBT)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            bountyEntry = ExtNBTKt.getToBountyEntry(it);
            collection.add(bountyEntry);
        }
        collection = (List)destination$iv$iv;
        valueRegistry.restore((List<BountyEntry>)collection);
    }

    @NotNull
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        boolean bl = false;
        boolean bl2 = false;
        CompoundNBT $this$apply = compoundNBT;
        boolean bl3 = false;
        $this$apply.func_74768_a(BountyNBT.BoardStamp.getKey(), this.boardStamp);
        $this$apply.func_74772_a(BountyNBT.BountyTime.getKey(), this.bountyTime);
        $this$apply.func_74768_a(BountyNBT.Rarity.getKey(), this.rarity);
        Long l = this.bountyStamp;
        if (l != null) {
            Long l2 = l;
            boolean bl4 = false;
            boolean bl5 = false;
            long it = ((Number)l2).longValue();
            boolean bl6 = false;
            $this$apply.func_74772_a(BountyNBT.BountyStamp.getKey(), it);
        }
        ExtNBTKt.setUnsortedList($this$apply, BountyNBT.Objectives.getKey(), CollectionsKt.toSet((Iterable)this.objectives.getContent()));
        ExtNBTKt.setUnsortedList($this$apply, BountyNBT.Rewards.getKey(), CollectionsKt.toSet((Iterable)this.rewards.getContent()));
        return compoundNBT;
    }

    /*
     * WARNING - void declaration
     */
    private final int assignRewards(BountyRarity inRarity, List<Decree> decrees) {
        BountyEntry[] bountyEntryArray;
        void $this$toTypedArray$iv;
        List<BountyEntry> toAdd = Companion.createRewards(inRarity, decrees);
        this.rarity = ArraysKt.indexOf((Object[])BountyRarity.values(), (Object)((Object)inRarity));
        Collection collection = toAdd;
        ValueRegistry<BountyEntry> valueRegistry = this.rewards;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        BountyEntry[] bountyEntryArray2 = thisCollection$iv.toArray(new BountyEntry[0]);
        if (bountyEntryArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        BountyEntry[] bountyEntryArray3 = bountyEntryArray = bountyEntryArray2;
        valueRegistry.add((BountyEntry[])Arrays.copyOf(bountyEntryArray3, bountyEntryArray3.length));
        Iterable $this$sumBy$iv = toAdd;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            BountyEntry bountyEntry = (BountyEntry)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it.getCalculatedWorth();
            sum$iv = n + n2;
        }
        int assignedWorth = sum$iv;
        return (int)((double)assignedWorth * inRarity.getWorthMult());
    }

    /*
     * WARNING - void declaration
     */
    private final void assignObjectives(BountyRarity inRarity, List<Decree> decrees, int worth) {
        BountyEntry[] bountyEntryArray;
        void $this$toTypedArray$iv;
        long l;
        List<BountyEntry> objs = Companion.createObjectives(this.rewards.getContent(), inRarity, decrees, worth);
        for (BountyEntry obj22 : objs) {
            long l2;
            if (obj22.getTimeMult() != null) {
                double d = worth;
                Object object = BountifulConfig.Companion.getSERVER().getTimeMultiplier().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"BountifulConfig.SERVER.timeMultiplier.get()");
                double d2 = d * ((Number)object).doubleValue();
                Double d3 = obj22.getTimeMult();
                if (d3 == null) {
                    Intrinsics.throwNpe();
                }
                l2 = (long)(d2 * d3);
            } else {
                double d = worth;
                Object object = BountifulConfig.Companion.getSERVER().getTimeMultiplier().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"BountifulConfig.SERVER.timeMultiplier.get()");
                l2 = (long)(d * ((Number)object).doubleValue());
            }
            this.bountyTime += l2;
        }
        long obj22 = this.bountyTime;
        long l3 = (long)((Number)BountifulConfig.Companion.getSERVER().getBountyTimeMin().get()).intValue() * (long)20;
        Object object = this;
        boolean bl = false;
        ((BountyData)object).bountyTime = l = Math.max(obj22, l3);
        Collection obj22 = objs;
        object = this.objectives;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        BountyEntry[] bountyEntryArray2 = thisCollection$iv.toArray(new BountyEntry[0]);
        if (bountyEntryArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        BountyEntry[] bountyEntryArray3 = bountyEntryArray = bountyEntryArray2;
        ((ValueRegistry)object).add(Arrays.copyOf(bountyEntryArray3, bountyEntryArray3.length));
    }

    static {
        Companion = new Companion(null);
        rando = new Random();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J8\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0007J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010\u0016\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lejektaflex/bountiful/data/bounty/BountyData$Companion;", "", "()V", "boardTickFreq", "", "bountyTickFreq", "maxTimeAtBoard", "", "getMaxTimeAtBoard", "()I", "rando", "Ljava/util/Random;", "create", "Lejektaflex/bountiful/data/bounty/BountyData;", "inRarity", "Lejektaflex/bountiful/data/bounty/enums/BountyRarity;", "decrees", "", "Lejektaflex/bountiful/data/structure/Decree;", "createObjectives", "Lejektaflex/bountiful/data/bounty/BountyEntry;", "rewards", "worth", "createRewards", "getObjectivesWithinVariance", "objs", "variance", "", "isValidBounty", "", "stack", "Lnet/minecraft/item/ItemStack;", "pickObjective", "objectives", "Lnet/minecraft/util/NonNullList;", "Bountiful"})
    public static final class Companion {
        public final int getMaxTimeAtBoard() {
            return ((Number)BountifulConfig.Companion.getSERVER().getBoardLifespan().get()).intValue() * 20;
        }

        public final boolean isValidBounty(@NotNull ItemStack stack) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            try {
                ItemStack $this$toData$iv = stack;
                boolean $i$f$toData = false;
                boolean bl2 = false;
                BountyData bountyData = new BountyData();
                boolean bl3 = false;
                boolean bl4 = false;
                INBTSerializable $this$apply$iv = bountyData;
                boolean bl5 = false;
                ItemStack itemStack = $this$toData$iv.getStack();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                $this$apply$iv.deserializeNBT((INBT)itemStack.func_77978_p());
                bl = true;
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final BountyData create(@NotNull BountyRarity inRarity, @NotNull List<Decree> decrees) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)inRarity), (String)"inRarity");
            Intrinsics.checkParameterIsNotNull(decrees, (String)"decrees");
            BountyData data = new BountyData();
            double d = data.assignRewards(inRarity, decrees);
            Object object = BountifulConfig.Companion.getSERVER().getWorthRatio().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"BountifulConfig.SERVER.worthRatio.get()");
            double toSatisfy = d * ((Number)object).doubleValue();
            data.assignObjectives(inRarity, decrees, (int)toSatisfy);
            return data;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<BountyEntry> createRewards(@NotNull BountyRarity inRarity, @NotNull List<Decree> decrees) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)inRarity), (String)"inRarity");
            Intrinsics.checkParameterIsNotNull(decrees, (String)"decrees");
            List<BountyEntry> rewards = DecreeRegistry.INSTANCE.getRewards(decrees);
            int n = 1;
            int numRewards = ExtMiscKt.hackyRandom(new IntRange(n, 2));
            int n2 = 0;
            List toAdd = new ArrayList();
            if ((double)rando.nextFloat() < inRarity.getExtraRewardChance()) {
                ++numRewards;
            }
            n2 = 0;
            int n3 = numRewards;
            while (n2 < n3) {
                void i;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = rewards;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    BountyEntry it = (BountyEntry)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv = toAdd;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void alreadyAdded;
                        BountyEntry bountyEntry = (BountyEntry)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        String string = alreadyAdded.getContent();
                        collection.add(string);
                    }
                    if (!(!((List)destination$iv$iv2).contains(it.getContent()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List totalRewards = (List)destination$iv$iv;
                if (totalRewards.isEmpty()) break;
                toAdd.add(BountyEntry.pick$default((BountyEntry)ExtMiscKt.weightedRandomNorm(totalRewards, inRarity.getExponent()), null, 1, null));
                ++i;
            }
            return toAdd;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<BountyEntry> getObjectivesWithinVariance(@NotNull List<? extends BountyEntry> objs, int worth, double variance) {
            void $this$filterTo$iv$iv;
            Map objGroups;
            void $this$groupByTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(objs, (String)"objs");
            double d = (double)worth * variance;
            boolean bl = false;
            double wRange = Math.ceil(d);
            Iterable $this$groupBy$iv = objs;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                BountyEntry it = (BountyEntry)element$iv$iv;
                boolean bl2 = false;
                Integer key$iv$iv = it.worthDistanceFrom(worth);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$filter$iv = objGroups = destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var14_17 = $this$filterTo$iv$iv;
            boolean bl4 = false;
            Iterator iterator = var14_17.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl5 = false;
                if (!(((Number)it.getKey()).doubleValue() <= wRange)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map groupsInRange = destination$iv$iv2;
            List totalObjs = CollectionsKt.flatten((Iterable)groupsInRange.values());
            return totalObjs;
        }

        @NotNull
        public final BountyEntry pickObjective(@NotNull NonNullList<BountyEntry> objectives, int worth) {
            BountyEntry bountyEntry;
            Intrinsics.checkParameterIsNotNull(objectives, (String)"objectives");
            double variance = 0.2;
            List<BountyEntry> inVariance = this.getObjectivesWithinVariance((List)objectives, worth, variance);
            if (inVariance.isEmpty()) {
                Object v0;
                Iterable $this$minBy$iv = (Iterable)objectives;
                boolean $i$f$minBy = false;
                Iterator iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        BountyEntry it = (BountyEntry)minElem$iv;
                        boolean bl = false;
                        int minValue$iv = it.worthDistanceFrom(worth);
                        do {
                            Object e$iv = iterator$iv.next();
                            BountyEntry it2 = (BountyEntry)e$iv;
                            $i$a$-minBy-BountyData$Companion$pickObjective$1 = false;
                            int v$iv = it2.worthDistanceFrom(worth);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                bountyEntry = ((BountyEntry)v0).pick(worth);
            } else {
                bountyEntry = ExtMiscKt.hackyRandom(inVariance).pick(worth);
            }
            return bountyEntry;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<BountyEntry> createObjectives(@NotNull List<? extends BountyEntry> rewards, @NotNull BountyRarity inRarity, @NotNull List<Decree> decrees, int worth) {
            void $this$filterTo$iv$iv;
            String string;
            Object object;
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(rewards, (String)"rewards");
            Intrinsics.checkParameterIsNotNull((Object)((Object)inRarity), (String)"inRarity");
            Intrinsics.checkParameterIsNotNull(decrees, (String)"decrees");
            Iterable $this$map$iv = rewards;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BountyEntry bountyEntry = (BountyEntry)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                string = it.getContent();
                object.add(string);
            }
            List rewardContentIds = (List)destination$iv$iv;
            Iterable $this$filter$iv = DecreeRegistry.INSTANCE.getObjectives(decrees);
            int $i$f$filter = 0;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BountyEntry it = (BountyEntry)element$iv$iv;
                boolean bl = false;
                if (!(!rewardContentIds.contains(it.getContent()))) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            List objectives = (List)destination$iv$iv22;
            $i$f$filter = 1;
            int numObjectives = ExtMiscKt.hackyRandom(new IntRange($i$f$filter, 2));
            if (objectives.isEmpty()) {
                $i$f$filter = 0;
                return CollectionsKt.emptyList();
            }
            List<Integer> worthGroups = ExtMiscKt.randomSplit(worth, numObjectives);
            boolean destination$iv$iv22 = false;
            List toAdd = new ArrayList();
            Iterator<Integer> iterator = worthGroups.iterator();
            while (iterator.hasNext()) {
                BountyEntry[] bountyEntryArray;
                void $this$toTypedArray$iv$iv;
                Collection $this$filterTo$iv$iv2;
                int wrth = ((Number)iterator.next()).intValue();
                Iterable $this$filter$iv2 = objectives;
                boolean $i$f$filter2 = false;
                Iterable bl = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    void $this$mapTo$iv$iv2;
                    BountyEntry it = (BountyEntry)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$map$iv2 = toAdd;
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void alreadyAdded;
                        BountyEntry bountyEntry = (BountyEntry)item$iv$iv;
                        Collection collection = destination$iv$iv4;
                        boolean bl3 = false;
                        String string2 = alreadyAdded.getContent();
                        collection.add(string2);
                    }
                    if (!(!((List)destination$iv$iv4).contains(it.getContent()))) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List pickableObjs = (List)destination$iv$iv3;
                if (pickableObjs.isEmpty()) break;
                object = this;
                boolean $i$f$supposedlyNotNull = false;
                $this$filterTo$iv$iv2 = pickableObjs;
                Object object2 = CollectionsKt.first((List)pickableObjs);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                if (thisCollection$iv$iv.toArray(new BountyEntry[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)NonNullList.func_193580_a((Object)object2, (Object[])Arrays.copyOf(bountyEntryArray, bountyEntryArray.length)), (String)"NonNullList.from<T>(list\u2026(), *list.toTypedArray())");
                BountyEntry closest = ((Companion)object).pickObjective((NonNullList<BountyEntry>)string, wrth);
                toAdd.add(closest);
            }
            return toAdd;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

