/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui.blocks;

import com.direwolf20.buildinggadgets.common.containers.ChargingStationContainer;
import com.direwolf20.buildinggadgets.common.tiles.ChargingStationTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;

public class ChargingStationGUI
extends ContainerScreen<ChargingStationContainer> {
    private static final ResourceLocation background = new ResourceLocation("buildinggadgets", "textures/gui/charging_station.png");
    private ChargingStationContainer container;
    private List<String> toolTip = new ArrayList<String>();

    public ChargingStationGUI(ChargingStationContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.container = container;
    }

    public ChargingStationGUI(ChargingStationTileEntity tileEntity, ChargingStationContainer container, PlayerInventory inv) {
        super((Container)container, inv, (ITextComponent)new StringTextComponent("Charging station"));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (mouseX > this.field_147003_i + 7 && mouseX < this.field_147003_i + 7 + 18 && mouseY > this.field_147009_r + 7 && mouseY < this.field_147009_r + 7 + 73) {
            this.renderTooltip(Arrays.asList(TooltipTranslation.CHARGER_ENERGY.format(GadgetUtils.withSuffix(this.container.getEnergy())), this.container.getTe().getRemainingBurn() <= 0 ? TooltipTranslation.CHARGER_EMPTY.format(new Object[0]) : TooltipTranslation.CHARGER_BURN.format(GadgetUtils.ticksInSeconds(this.container.getTe().getRemainingBurn()))), mouseX, mouseY);
        }
        this.toolTip.clear();
    }

    public void init() {
        super.init();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(background);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int maxHeight = 13;
        if (this.container.getTe().getMaxBurn() > 0) {
            int remaining = this.container.getTe().getRemainingBurn() * maxHeight / this.container.getTe().getMaxBurn();
            this.blit(this.field_147003_i + 66, this.field_147009_r + 26 + 13 - remaining, 176, 13 - remaining, 14, remaining + 1);
        }
        this.container.getTe().getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> {
            int height = 68;
            if (energy.getMaxEnergyStored() > 0) {
                int remaining = energy.getEnergyStored() * height / energy.getMaxEnergyStored();
                this.blit(this.field_147003_i + 8, this.field_147009_r + 76 - remaining, 176, 83 - remaining, 16, remaining + 1);
            }
        });
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_211126_b(I18n.func_135052_a((String)"block.buildinggadgets.charging_station", (Object[])new Object[0]), 55.0f, 8.0f, Color.DARK_GRAY.getRGB());
    }
}

