/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui.components;

import com.direwolf20.buildinggadgets.client.ClientProxy;
import com.direwolf20.buildinggadgets.client.gui.GuiMod;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketChangeRange;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Collection;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiSliderInt
extends GuiSlider {
    private int colorBackground;
    private int colorSliderBackground;
    private int colorSlider;
    private BiConsumer<GuiSliderInt, Integer> increment;
    private int value;

    public GuiSliderInt(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Color color, Button.IPressable par, BiConsumer<GuiSliderInt, Integer> increment) {
        super(xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, par);
        this.colorBackground = GuiMod.getColor(color, 200).getRGB();
        this.colorSliderBackground = GuiMod.getColor(color.darker(), 200).getRGB();
        this.colorSlider = GuiMod.getColor(color.brighter().brighter(), 200).getRGB();
        this.increment = increment;
    }

    public void onRelease(double mouseX, double mouseY) {
        super.onRelease(mouseX, mouseY);
        this.setValue(this.getValueInt());
    }

    public void updateSlider() {
        super.updateSlider();
        int valueInt = this.getValueInt();
        if (this.value != valueInt) {
            this.value = valueInt;
            this.playSound();
            PacketHandler.sendToServer(new PacketChangeRange(this.getValueInt()));
        }
    }

    private void playSound() {
        ClientProxy.playSound(SoundEvents.field_187576_at, 2.0f);
    }

    public void render(int mouseX, int mouseY, float partial) {
        if (!this.visible) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        GuiSliderInt.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.colorBackground);
        this.renderBg(mc, mouseX, mouseY);
        this.renderText(mc, (Button)this);
    }

    private void renderText(Minecraft mc, Button component) {
        int color = !this.active ? 0xA0A0A0 : (this.isHovered ? 0xFFFFA0 : -1);
        String buttonText = component.getMessage();
        int strWidth = mc.field_71466_p.func_78256_a(buttonText);
        int ellipsisWidth = mc.field_71466_p.func_78256_a("...");
        if (strWidth > component.getWidth() - 6 && strWidth > ellipsisWidth) {
            buttonText = mc.field_71466_p.func_78269_a(buttonText, component.getWidth() - 6 - ellipsisWidth).trim() + "...";
        }
        this.drawCenteredString(mc.field_71466_p, buttonText, component.x + component.getWidth() / 2, component.y + (component.getHeight() - 8) / 2, color);
    }

    public void playDownSound(SoundHandler p_playDownSound_1_) {
    }

    protected void renderBg(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        if (this.dragging) {
            this.sliderValue = (float)(mouseX - (this.x + 4)) / (float)(this.width - 8);
            this.updateSlider();
        }
        this.drawBorderedRect(this.x + (int)(this.sliderValue * (double)(this.width - 8)), this.y, 8, this.height);
    }

    private void drawBorderedRect(int x, int y, int width, int height) {
        GuiSliderInt.fill((int)x, (int)y, (int)(x + width), (int)(y + height), (int)this.colorSliderBackground);
        GuiSliderInt.fill((int)(++x), (int)(++y), (int)(x + width - 2), (int)(y + height - 2), (int)this.colorSlider);
    }

    public Collection<Button> getComponents() {
        return ImmutableSet.of((Object)((Object)this), (Object)((Object)new GuiButtonIncrement(this, this.x - this.height, this.y, this.height, this.height, "-", b -> this.increment.accept(this, -1))), (Object)((Object)new GuiButtonIncrement(this, this.x + this.width, this.y, this.height, this.height, "+", b -> this.increment.accept(this, 1))));
    }

    private static class GuiButtonIncrement
    extends Button {
        private GuiSliderInt parent;

        public GuiButtonIncrement(GuiSliderInt parent, int x, int y, int width, int height, String buttonText, Button.IPressable action) {
            super(x, y, width, height, buttonText, action);
            this.parent = parent;
        }

        public void render(int mouseX, int mouseY, float partial) {
            if (!this.visible) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            GuiButtonIncrement.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.parent.colorBackground);
            this.parent.drawBorderedRect(this.x, this.y, this.width, this.height);
            this.parent.renderText(mc, this);
        }

        public void playDownSound(SoundHandler p_playDownSound_1_) {
        }
    }
}

