/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui.components;

import java.util.function.BiConsumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;

public class GuiTextFieldBase
extends TextFieldWidget {
    private boolean suspended;
    private String valueDefault;
    private String valueOld;
    private BiConsumer<GuiTextFieldBase, String> postModification;

    public GuiTextFieldBase(FontRenderer fontRenderer, int x, int y, int width) {
        super(fontRenderer, x, y, width, 15, "Hello?");
        this.func_146203_f(50);
        this.func_200675_a(s -> {
            this.valueOld = this.func_146179_b();
            return true;
        });
    }

    public void func_146180_a(String textIn) {
        super.func_146180_a(textIn);
        this.postModification(textIn);
    }

    public void postModification(String text) {
        if (!this.suspended && this.postModification != null) {
            this.suspended = true;
            this.postModification.accept(this, this.valueOld);
            this.suspended = false;
        }
    }

    public GuiTextFieldBase onPostModification(BiConsumer<GuiTextFieldBase, String> postModification) {
        this.postModification = postModification;
        return this;
    }

    public GuiTextFieldBase restrictToNumeric() {
        this.func_200675_a(s -> {
            this.valueOld = this.func_146179_b();
            if (s == null || s.isEmpty() || "-".equals(s)) {
                return true;
            }
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        return this;
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.func_146179_b());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public GuiTextFieldBase setDefaultInt(int defaultInt) {
        return this.setDefaultValue(Integer.toString(defaultInt));
    }

    public GuiTextFieldBase setDefaultValue(String defaultValue) {
        this.valueDefault = defaultValue;
        return this;
    }

    public String getDefaultValue() {
        return this.valueDefault;
    }
}

