/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui.materiallist;

import com.direwolf20.buildinggadgets.client.gui.materiallist.ScrollingMaterialList;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.template.Template;
import com.direwolf20.buildinggadgets.common.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.lang.MaterialListTranslation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.client.config.GuiUtils;

public class MaterialListGUI
extends Screen
implements ITemplateProvider.IUpdateListener {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTONS_PADDING = 4;
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("buildinggadgets", "textures/gui/material_list.png");
    public static final int BACKGROUND_WIDTH = 256;
    public static final int BACKGROUND_HEIGHT = 200;
    public static final int BORDER_SIZE = 4;
    public static final int WINDOW_WIDTH = 248;
    public static final int WINDOW_HEIGHT = 192;
    private int backgroundX;
    private int backgroundY;
    private ItemStack item;
    private String title;
    private int titleLeft;
    private int titleTop;
    private ScrollingMaterialList scrollingList;
    private Button buttonClose;
    private Button buttonSortingModes;
    private Button buttonCopyList;
    private int hoveringTextX;
    private int hoveringTextY;
    private List<String> hoveringText;
    private TemplateHeader header;

    public static int getXForAlignedRight(int right, int width) {
        return right - width;
    }

    public static int getXForAlignedCenter(int left, int right, int width) {
        return left + (right - left) / 2 - width / 2;
    }

    public static int getYForAlignedCenter(int top, int bottom, int height) {
        return top + (bottom - top) / 2 - height / 2;
    }

    public static int getYForAlignedBottom(int bottom, int height) {
        return bottom - height;
    }

    public static void renderTextVerticalCenter(String text, int leftX, int top, int bottom, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.getClass();
        int y = MaterialListGUI.getYForAlignedCenter(top, bottom, 9);
        GlStateManager.enableTexture();
        fontRenderer.func_211126_b(text, (float)leftX, (float)y, color);
    }

    public static void renderTextHorizontalRight(String text, int right, int y, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int x = MaterialListGUI.getXForAlignedRight(right, fontRenderer.func_78256_a(text));
        GlStateManager.enableTexture();
        fontRenderer.func_211126_b(text, (float)x, (float)y, color);
    }

    public static boolean isPointInBox(double x, double y, int bx, int by, int width, int height) {
        return x >= (double)bx && y >= (double)by && x < (double)(bx + width) && y < (double)(by + height);
    }

    public MaterialListGUI(ItemStack item) {
        super((ITextComponent)MaterialListTranslation.TITLE.componentTranslation(new Object[0]));
        Preconditions.checkArgument((boolean)item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).isPresent());
        this.item = item;
    }

    public void init() {
        this.backgroundX = MaterialListGUI.getXForAlignedCenter(0, this.width, 256);
        this.backgroundY = MaterialListGUI.getYForAlignedCenter(0, this.height, 200);
        this.header = this.evaluateTemplateHeader();
        this.evaluateTitle();
        this.scrollingList = new ScrollingMaterialList(this);
        this.setFocused((IGuiEventListener)this.scrollingList);
        this.children.add(this.scrollingList);
        int buttonY = this.getWindowBottomY() - 26;
        this.buttonClose = new Button(0, buttonY, 0, 20, MaterialListTranslation.BUTTON_CLOSE.format(new Object[0]), b -> Minecraft.func_71410_x().field_71439_g.func_71053_j());
        this.buttonSortingModes = new Button(0, buttonY, 0, 20, this.scrollingList.getSortingMode().getLocalizedName(), button -> {
            this.scrollingList.setSortingMode(this.scrollingList.getSortingMode().next());
            this.buttonSortingModes.setMessage(this.scrollingList.getSortingMode().getLocalizedName());
        });
        this.buttonCopyList = new Button(0, buttonY, 0, 20, MaterialListTranslation.BUTTON_COPY.format(new Object[0]), button -> {
            this.getMinecraft().field_195559_v.func_197960_a(this.stringify(Screen.hasControlDown()));
            this.getMinecraft().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent(MaterialListTranslation.MESSAGE_COPY_SUCCESS.getTranslationKey(), new Object[0]), true);
        });
        this.addButton((Widget)this.buttonSortingModes);
        this.addButton((Widget)this.buttonCopyList);
        this.addButton((Widget)this.buttonClose);
        this.children.add(this.scrollingList);
        this.calculateButtonsWidthAndX();
    }

    private String stringify(boolean detailed) {
        if (detailed) {
            return this.stringifyDetailed();
        }
        return this.stringifySimple();
    }

    private String stringifyDetailed() {
        return this.evaluateTemplateHeader().toJson(false, true);
    }

    private String stringifySimple() {
        return this.evaluateTemplateHeader().toJson(false, false);
    }

    public TemplateHeader evaluateTemplateHeader() {
        Template template = this.getTemplateCapability();
        SimpleBuildContext context = SimpleBuildContext.builder().buildingPlayer((PlayerEntity)this.getMinecraft().field_71439_g).usedStack(this.getTemplateItem()).build((IWorld)this.getMinecraft().field_71441_e);
        return template.getHeaderAndForceMaterials(context);
    }

    public TemplateHeader getHeader() {
        return this.header;
    }

    public void render(int mouseX, int mouseY, float particleTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        GuiUtils.drawTexturedModalRect((int)this.backgroundX, (int)this.backgroundY, (int)0, (int)0, (int)256, (int)200, (float)0.0f);
        this.scrollingList.render(mouseX, mouseY, particleTicks);
        this.drawString(this.font, this.title, this.titleLeft, this.titleTop, Color.WHITE.getRGB());
        super.render(mouseX, mouseY, particleTicks);
        if (this.buttonCopyList.isMouseOver((double)mouseX, (double)mouseY)) {
            GuiUtils.drawHoveringText((List)ImmutableList.of((Object)MaterialListTranslation.HELP_COPY_LIST.format(new Object[0])), (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)Integer.MAX_VALUE, (FontRenderer)this.font);
        } else if (this.hoveringText != null) {
            GuiUtils.drawHoveringText(this.hoveringText, (int)this.hoveringTextX, (int)this.hoveringTextY, (int)this.width, (int)this.height, (int)Integer.MAX_VALUE, (FontRenderer)this.font);
            this.hoveringText = null;
        }
    }

    private void calculateButtonsWidthAndX() {
        int amountButtons = this.buttons.size();
        int amountMargins = amountButtons - 1;
        int totalMarginWidth = amountMargins * 4;
        int usableWidth = this.getWindowWidth();
        int buttonWidth = (usableWidth - totalMarginWidth) / amountButtons;
        int nextX = this.getWindowLeftX();
        for (Widget widget : this.buttons) {
            widget.setWidth(buttonWidth);
            widget.x = nextX;
            nextX += buttonWidth + 4;
        }
    }

    public int getWindowLeftX() {
        return this.backgroundX + 4;
    }

    public int getWindowRightX() {
        return this.backgroundX + 256 - 4;
    }

    public int getWindowTopY() {
        return this.backgroundY + 4;
    }

    public int getWindowBottomY() {
        return this.backgroundY + 200 - 4;
    }

    public int getWindowWidth() {
        return 248;
    }

    public int getWindowHeight() {
        return 192;
    }

    public ItemStack getTemplateItem() {
        return this.item;
    }

    public Template getTemplateCapability() {
        LazyOptional providerCap = Minecraft.func_71410_x().field_71441_e.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY);
        if (providerCap.isPresent()) {
            LazyOptional keyCap = this.item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY);
            ITemplateProvider provider = (ITemplateProvider)providerCap.orElseThrow(RuntimeException::new);
            if (keyCap.isPresent()) {
                provider.registerUpdateListener(this);
                ITemplateKey key = (ITemplateKey)keyCap.orElseThrow(RuntimeException::new);
                return provider.getTemplateForKey(key);
            }
            BuildingGadgets.LOG.warn("Item used for material list does not have an ITemplateKey capability!");
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return null;
        }
        BuildingGadgets.LOG.warn("Client world used for material list does not have an ITemplateProvider capability!");
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
        return null;
    }

    public void setTaskHoveringText(int x, int y, List<String> text) {
        this.hoveringTextX = x;
        this.hoveringTextY = y;
        this.hoveringText = text;
    }

    @Override
    public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey key, Template template) {
        this.item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(itemKey -> {
            UUID itemId;
            UUID keyId = provider.getId(key);
            if (keyId.equals(itemId = provider.getId((ITemplateKey)itemKey))) {
                this.header = this.evaluateTemplateHeader();
                this.evaluateTitle();
                this.scrollingList.reset();
            }
        });
    }

    private void evaluateTitle() {
        String name = this.getHeader().getName();
        String author = this.getHeader().getAuthor();
        this.title = name == null && author == null ? MaterialListTranslation.TITLE_EMPTY.format(new Object[0]) : (name == null ? MaterialListTranslation.TITLE_AUTHOR_ONLY.format(author) : (author == null ? MaterialListTranslation.TITLE_NAME_ONLY.format(name) : MaterialListTranslation.TITLE.format(name, author)));
        int n = this.getWindowTopY() + 16;
        this.font.getClass();
        this.titleTop = MaterialListGUI.getYForAlignedCenter(this.backgroundY, n, 9);
        this.titleLeft = MaterialListGUI.getXForAlignedCenter(this.backgroundX, this.getWindowRightX(), this.font.func_78256_a(this.title));
    }
}

