/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.items.ChargingStationItem;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ChargingStationTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChargingStationBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public ChargingStationBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)LIT, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{LIT});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        List drops = super.func_220076_a(state, builder);
        if (te instanceof ChargingStationTileEntity) {
            ChargingStationTileEntity tileEntity = (ChargingStationTileEntity)te;
            ArrayList<ItemStack> res = new ArrayList<ItemStack>(drops.size());
            for (ItemStack stack : drops) {
                if (stack.func_77973_b() instanceof ChargingStationItem) {
                    tileEntity.onStoreEnergy(stack);
                }
                res.add(stack);
            }
            return res;
        }
        return drops;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != this) {
            GadgetUtils.dropTileEntityInventory(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return OurBlocks.OurTileEntities.CHARGING_STATION_TYPE.func_200968_a();
    }

    @Deprecated
    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof ChargingStationTileEntity)) {
            return false;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
        return true;
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 14 : 0;
    }
}

