/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.modes;

import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.modes.BuildToMeMode;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingHorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingSurfaceMode;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingVerticalColumnMode;
import com.direwolf20.buildinggadgets.common.building.modes.GridMode;
import com.direwolf20.buildinggadgets.common.building.modes.HorizontalWallMode;
import com.direwolf20.buildinggadgets.common.building.modes.IBuildingMode;
import com.direwolf20.buildinggadgets.common.building.modes.StairMode;
import com.direwolf20.buildinggadgets.common.building.modes.VerticalWallMode;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.SortingHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public enum BuildingMode {
    TARGETED_AXIS_CHASING("build_to_me.png", new BuildToMeMode(BuildingMode::combineTester)),
    VERTICAL_COLUMN("vertical_column.png", new BuildingVerticalColumnMode(BuildingMode::combineTester)),
    HORIZONTAL_COLUMN("horizontal_column.png", new BuildingHorizontalColumnMode(BuildingMode::combineTester)),
    VERTICAL_WALL("vertical_wall.png", new VerticalWallMode(BuildingMode::combineTester)),
    HORIZONTAL_WALL("horizontal_wall.png", new HorizontalWallMode(BuildingMode::combineTester)),
    STAIR("stairs.png", new StairMode(BuildingMode::combineTester)),
    GRID("grid.png", new GridMode(BuildingMode::combineTester)),
    SURFACE("surface.png", new BuildingSurfaceMode(BuildingMode::combineTester));

    private static final BuildingMode[] VALUES;
    private final ResourceLocation icon;
    private final IBuildingMode modeImpl;
    private static final ImmutableList<ResourceLocation> ICONS;

    private BuildingMode(String iconFile, IBuildingMode modeImpl) {
        this.icon = new ResourceLocation("buildinggadgets", "textures/gui/mode/" + iconFile);
        this.modeImpl = modeImpl;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public IBuildingMode getModeImplementation() {
        return this.modeImpl;
    }

    public String getRegistryName() {
        return this.getModeImplementation().getRegistryName().toString() + "/BuildingGadget";
    }

    public String toString() {
        return this.getModeImplementation().getLocalizedName();
    }

    public BuildingMode next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static List<BlockPos> collectPlacementPos(IWorld world, PlayerEntity player, BlockPos hit, Direction sideHit, ItemStack tool, BlockPos initial) {
        IBuildingMode mode = BuildingMode.byName(NBTHelper.getOrNewTag(tool).func_74779_i("mode")).getModeImplementation();
        return SortingHelper.Blocks.byDistance(mode.createExecutionContext(player, hit, sideHit, tool, initial).getFilteredSequence().stream(), Function.identity(), player).collect(Collectors.toCollection(LinkedList::new));
    }

    public static BuildingMode byName(String name) {
        return Arrays.stream(VALUES).filter(mode -> mode.getRegistryName().equals(name)).findFirst().orElse(TARGETED_AXIS_CHASING);
    }

    public static ImmutableList<ResourceLocation> getIcons() {
        return ICONS;
    }

    public static BiPredicate<BlockPos, BlockData> combineTester(IWorld world, ItemStack tool, PlayerEntity player, BlockPos original) {
        BlockData target = GadgetUtils.getToolBlock(tool);
        return (pos, data) -> {
            BlockState current = world.func_180495_p(pos);
            if (!target.getState().func_196955_c((IWorldReader)world, pos)) {
                return false;
            }
            if (pos.func_177956_o() < 0) {
                return false;
            }
            if (((Boolean)Config.GENERAL.allowOverwriteBlocks.get()).booleanValue()) {
                return current.func_196953_a(new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, VectorHelper.getLookingAt(player, tool))));
            }
            return current.isAir((IBlockReader)world, pos);
        };
    }

    static {
        VALUES = BuildingMode.values();
        ICONS = (ImmutableList)Arrays.stream(VALUES).map(BuildingMode::getIcon).collect(ImmutableList.toImmutableList());
    }
}

