/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.modes;

import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingGridMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingHorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingSurfaceMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingVerticalColumnMode;
import com.direwolf20.buildinggadgets.common.building.modes.IBuildingMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.SortingHelper;
import com.direwolf20.buildinggadgets.common.world.FakeDelegationWorld;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public enum ExchangingMode {
    SURFACE("surface.png", new ExchangingSurfaceMode(ExchangingMode::combineTester)),
    VERTICAL_COLUMN("vertical_column.png", new ExchangingVerticalColumnMode(ExchangingMode::combineTester)),
    HORIZONTAL_COLUMN("horizontal_column.png", new ExchangingHorizontalColumnMode(ExchangingMode::combineTester)),
    GRID("grid.png", new ExchangingGridMode(ExchangingMode::combineTester));

    private static final ExchangingMode[] VALUES;
    private final ResourceLocation icon;
    private final IBuildingMode modeImpl;
    private static final ImmutableList<ResourceLocation> ICONS;

    private ExchangingMode(String iconFile, IBuildingMode modeImpl) {
        this.icon = new ResourceLocation("buildinggadgets", "textures/gui/mode/" + iconFile);
        this.modeImpl = modeImpl;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public IBuildingMode getModeImplementation() {
        return this.modeImpl;
    }

    public String getRegistryName() {
        return this.getModeImplementation().getRegistryName().toString() + "/ExchangingGadget";
    }

    public String toString() {
        return this.getModeImplementation().getLocalizedName();
    }

    public ExchangingMode next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static ExchangingMode byName(String name) {
        return Arrays.stream(VALUES).filter(mode -> mode.getRegistryName().equals(name)).findFirst().orElse(SURFACE);
    }

    public static ImmutableList<ResourceLocation> getIcons() {
        return ICONS;
    }

    public static List<BlockPos> collectPlacementPos(IWorld world, PlayerEntity player, BlockPos hit, Direction sideHit, ItemStack tool, BlockPos initial) {
        IBuildingMode mode = ExchangingMode.byName(NBTHelper.getOrNewTag(tool).func_74779_i("mode")).getModeImplementation();
        return SortingHelper.Blocks.byDistance(mode.createExecutionContext(player, hit, sideHit, tool, initial).getFilteredSequence().stream(), Function.identity(), player).collect(Collectors.toCollection(LinkedList::new));
    }

    public static BiPredicate<BlockPos, BlockData> combineTester(IWorld world, ItemStack tool, PlayerEntity player, BlockPos initial) {
        BlockState initialBlockState = world.func_180495_p(initial);
        BlockData target = GadgetUtils.getToolBlock(tool);
        FakeDelegationWorld fakeWorld = new FakeDelegationWorld(world);
        return (pos, data) -> {
            fakeWorld.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 0);
            if (!target.getState().func_196955_c((IWorldReader)fakeWorld, pos)) {
                return false;
            }
            fakeWorld.func_180501_a((BlockPos)pos, data.getState(), 0);
            BlockState worldBlockState = world.func_180495_p(pos);
            if (worldBlockState == target.getState()) {
                return false;
            }
            if (!AbstractGadget.getFuzzy(tool) && worldBlockState.func_177230_c() != initialBlockState.func_177230_c()) {
                return false;
            }
            if (worldBlockState == OurBlocks.effectBlock.func_176223_P()) {
                return false;
            }
            if (worldBlockState.isAir((IBlockReader)world, pos)) {
                return false;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)tile).getConstructionBlockData().equals(data) : tile != null) {
                return false;
            }
            if (worldBlockState.func_185887_b((IBlockReader)world, pos) < 0.0f) {
                return false;
            }
            boolean hasVisibleSide = false;
            for (Direction dir : Direction.values()) {
                BlockPos offset = pos.func_177972_a(dir);
                if (fakeWorld.func_180495_p(offset).doesSideBlockRendering((IEnviromentBlockReader)fakeWorld, pos, dir.func_176734_d())) continue;
                hasVisibleSide = true;
                break;
            }
            if (!hasVisibleSide) {
                return false;
            }
            return !worldBlockState.func_185904_a().func_76224_d();
        };
    }

    static {
        VALUES = ExchangingMode.values();
        ICONS = (ImmutableList)Arrays.stream(VALUES).map(ExchangingMode::getIcon).collect(ImmutableList.toImmutableList());
    }
}

