/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.modes;

import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.IBlockProvider;
import com.direwolf20.buildinggadgets.common.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildView;
import com.direwolf20.buildinggadgets.common.capability.CapabilityBlockProvider;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;

public interface IBuildingMode {
    public IPositionPlacementSequence computeCoordinates(PlayerEntity var1, BlockPos var2, Direction var3, ItemStack var4);

    default public IBlockProvider getBlockProvider(ItemStack tool) {
        LazyOptional capability = tool.getCapability(CapabilityBlockProvider.BLOCK_PROVIDER, null);
        return (IBlockProvider)capability.orElse((Object)CapabilityBlockProvider.getDefaultAirProvider());
    }

    public BiPredicate<BlockPos, BlockData> createValidatorFor(IWorld var1, ItemStack var2, PlayerEntity var3, BlockPos var4);

    default public SimpleBuildView createExecutionContext(PlayerEntity player, BlockPos hit, Direction sideHit, ItemStack tool, @Nullable BlockPos initial) {
        return new SimpleBuildView(this.computeCoordinates(player, hit, sideHit, tool), this.getBlockProvider(tool), this::createValidatorFor, SimpleBuildContext.builder().buildingPlayer(player).usedStack(tool).build(), initial);
    }

    public ResourceLocation getRegistryName();

    public String getLocalizedName();
}

