/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.IPositionPlacementSequence;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public class SetBackedPlacementSequence
implements IPositionPlacementSequence,
Serializable {
    private static final long serialVersionUID = 3372886441086287285L;
    private Region boundingBox;
    private Set<BlockPos> internalSet;

    public SetBackedPlacementSequence(@Nonnull Set<BlockPos> internalSet, @Nonnull Region boundingBox) {
        this.internalSet = ImmutableSet.copyOf((Collection)Objects.requireNonNull(internalSet));
        this.boundingBox = Objects.requireNonNull(boundingBox);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return this.internalSet.iterator();
    }

    @Override
    @Nonnull
    public Region getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    @Deprecated
    public boolean mayContain(int x, int y, int z) {
        return this.contains(new BlockPos(x, y, z));
    }

    public boolean contains(int x, int y, int z) {
        return this.contains(new BlockPos(x, y, z));
    }

    public boolean contains(BlockPos pos) {
        return this.internalSet.contains(pos);
    }

    @Override
    @Nonnull
    public IPositionPlacementSequence copy() {
        return new SetBackedPlacementSequence(this.internalSet, this.boundingBox);
    }

    public Set<BlockPos> getInternalSet() {
        return this.internalSet;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.boundingBox = (Region)in.readObject();
        this.internalSet = new LinkedHashSet<BlockPos>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.internalSet.add(new BlockPos(in.readInt(), in.readInt(), in.readInt()));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.boundingBox);
        out.writeInt(this.internalSet.size());
        for (BlockPos pos : this.internalSet) {
            out.writeInt(pos.func_177958_n());
            out.writeInt(pos.func_177956_o());
            out.writeInt(pos.func_177952_p());
        }
    }
}

