/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.view;

import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.util.spliterator.MappingSpliterator;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public final class PositionalBuildView
implements IBuildView {
    private Map<BlockPos, BlockData> map;
    private Region boundingBox;
    private BlockPos translation;
    private IBuildContext context;

    public static <T> PositionalBuildView ofIterable(IBuildContext context, Iterable<T> iterable, Function<? super T, ? extends BlockPos> keyExtractor, Function<? super T, BlockData> dataExtractor) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Region.Builder regBuilder = iterable.iterator().hasNext() ? Region.enclosingBuilder() : Region.builder();
        for (T target : iterable) {
            BlockPos pos = keyExtractor.apply(target);
            BlockData data = dataExtractor.apply(target);
            builder.put((Object)pos, (Object)data);
            regBuilder.enclose((Vec3i)pos);
        }
        return PositionalBuildView.createUnsafe(context, (Map<BlockPos, BlockData>)builder.build(), regBuilder.build());
    }

    public static PositionalBuildView ofIterable(IBuildContext context, Iterable<PlacementTarget> iterable) {
        return PositionalBuildView.ofIterable(context, iterable, PlacementTarget::getPos, PlacementTarget::getData);
    }

    public static PositionalBuildView create(IBuildContext context, Map<BlockPos, BlockData> map) {
        if (map instanceof ImmutableMap) {
            Region.Builder regBuilder = map.isEmpty() ? Region.builder() : Region.enclosingBuilder();
            for (BlockPos pos : map.keySet()) {
                regBuilder.enclose((Vec3i)pos);
            }
            return PositionalBuildView.createUnsafe(context, map, regBuilder.build());
        }
        return PositionalBuildView.ofIterable(context, map.entrySet(), Map.Entry::getKey, Map.Entry::getValue);
    }

    public static PositionalBuildView createUnsafe(IBuildContext context, Map<BlockPos, BlockData> map, Region boundingBox) {
        return new PositionalBuildView(Objects.requireNonNull(context, "Cannot have a PositionalBuildView without BuildContext!"), Objects.requireNonNull(map, "Cannot have a PositionalBuildView without position to data map!"), Objects.requireNonNull(boundingBox, "Cannot have a PositionalBuildView without a boundingBox!"));
    }

    private PositionalBuildView(IBuildContext context, Map<BlockPos, BlockData> map, Region boundingBox) {
        this.context = context;
        this.map = map;
        this.boundingBox = boundingBox;
        this.translation = BlockPos.field_177992_a;
    }

    @Override
    public Spliterator<PlacementTarget> spliterator() {
        BlockPos translation = this.translation;
        return new MappingSpliterator<Map.Entry, PlacementTarget>(this.map.entrySet().spliterator(), e -> new PlacementTarget(((BlockPos)e.getKey()).func_177971_a((Vec3i)translation), (BlockData)e.getValue()));
    }

    @Override
    public PositionalBuildView translateTo(BlockPos pos) {
        this.boundingBox = this.boundingBox.translate((Vec3i)pos.func_177973_b((Vec3i)this.translation));
        this.translation = pos;
        return this;
    }

    @Override
    public int estimateSize() {
        return this.map.size();
    }

    @Override
    public PositionalBuildView copy() {
        return new PositionalBuildView(this.context, this.map, this.boundingBox);
    }

    @Override
    public IBuildContext getContext() {
        return this.context;
    }

    @Override
    public Region getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.map.containsKey(new BlockPos(x, y, z));
    }

    public ImmutableMap<BlockPos, BlockData> getMap() {
        return ImmutableMap.copyOf(this.map);
    }
}

