/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.view;

import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.building.view.PositionalBuildView;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.util.spliterator.DelegatingSpliterator;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public final class WorldBuildView
implements IBuildView {
    private final IBuildContext context;
    private final Region region;
    private final BiFunction<IBuildContext, BlockPos, Optional<BlockData>> dataFactory;
    private BlockPos translation;

    public static WorldBuildView inWorld(IWorld world, Region region) {
        return WorldBuildView.create(SimpleBuildContext.builder().build(world), region);
    }

    public static WorldBuildView create(IBuildContext context, Region region) {
        return WorldBuildView.create(context, region, null);
    }

    public static WorldBuildView create(IBuildContext context, Region region, @Nullable BiFunction<IBuildContext, BlockPos, Optional<BlockData>> dataFactory) {
        return new WorldBuildView(Objects.requireNonNull(context, "Cannot create WorldBuildView without an IBuildContext!"), Objects.requireNonNull(region, "Cannot create WorldBuildView without an Region!"), dataFactory != null ? dataFactory : (c, p) -> Optional.of(TileSupport.createBlockData((IBlockReader)c.getWorld(), p)));
    }

    private WorldBuildView(IBuildContext context, Region region, BiFunction<IBuildContext, BlockPos, Optional<BlockData>> dataFactory) {
        this.context = context;
        this.region = region;
        this.dataFactory = dataFactory;
        this.translation = BlockPos.field_177992_a;
    }

    @Override
    public Spliterator<PlacementTarget> spliterator() {
        return new WorldBackedSpliterator(this.getBoundingBox().spliterator(), this.translation, this.dataFactory, this.getContext());
    }

    @Override
    public WorldBuildView translateTo(BlockPos pos) {
        this.translation = pos;
        return this;
    }

    @Override
    public int estimateSize() {
        return this.region.size();
    }

    @Override
    public WorldBuildView copy() {
        return new WorldBuildView(this.getContext(), this.getBoundingBox(), this.dataFactory);
    }

    public PositionalBuildView evaluate() {
        return PositionalBuildView.ofIterable(this.getContext(), this);
    }

    @Override
    public IBuildContext getContext() {
        return this.context;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.region.mayContain(x, y, z) && this.dataFactory.apply(this.getContext(), new BlockPos(x, y, z)).isPresent();
    }

    private static final class WorldBackedSpliterator
    extends DelegatingSpliterator<BlockPos, PlacementTarget> {
        private final BlockPos translation;
        private final BiFunction<IBuildContext, BlockPos, Optional<BlockData>> dataFactory;
        private final IBuildContext context;

        private WorldBackedSpliterator(Spliterator<BlockPos> other, BlockPos translation, BiFunction<IBuildContext, BlockPos, Optional<BlockData>> dataFactory, IBuildContext context) {
            super(other);
            this.translation = translation;
            this.dataFactory = dataFactory;
            this.context = context;
        }

        @Override
        protected boolean advance(BlockPos object, Consumer<? super PlacementTarget> action) {
            Optional<BlockData> dataOptional = this.dataFactory.apply(this.context, object);
            if (dataOptional.isPresent()) {
                BlockData data = dataOptional.get();
                action.accept(new PlacementTarget(object.func_177971_a((Vec3i)this.translation), data));
                return true;
            }
            return false;
        }

        @Override
        public Comparator<? super PlacementTarget> getComparator() {
            return Comparator.comparing(PlacementTarget::getPos);
        }

        @Override
        @Nullable
        public Spliterator<PlacementTarget> trySplit() {
            Spliterator<BlockPos> other = this.getOther().trySplit();
            if (other != null) {
                return new WorldBackedSpliterator(other, this.translation, this.dataFactory, this.context);
            }
            return null;
        }

        @Override
        public int characteristics() {
            return 21;
        }
    }
}

