/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.containers;

import com.direwolf20.buildinggadgets.common.containers.BaseContainer;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.registry.OurContainers;
import com.direwolf20.buildinggadgets.common.tiles.ChargingStationTileEntity;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ChargingStationContainer
extends BaseContainer {
    private ChargingStationTileEntity te;

    public ChargingStationContainer(int windowId, PlayerInventory playerInventory, PacketBuffer extraData) {
        super(OurContainers.CHARGING_STATION_CONTAINER, windowId);
        BlockPos pos = extraData.func_179259_c();
        this.te = (ChargingStationTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory);
    }

    public ChargingStationContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super(OurContainers.CHARGING_STATION_CONTAINER, windowId);
        this.te = (ChargingStationTileEntity)world.func_175625_s(pos);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.getTe().canInteractWith(playerIn);
    }

    private void addOwnSlots() {
        IItemHandler itemHandler = (IItemHandler)this.getTe().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(CapabilityNotPresentException::new);
        int y = 43;
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 0, 65, y));
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 1, 119, y));
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity p_82846_1_, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index < 2) {
                if (!this.func_75135_a(stack, 2, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else {
                int burnTime = ForgeHooks.getBurnTime((ItemStack)stack);
                if (stack.func_77973_b() instanceof AbstractGadget ? !this.func_75135_a(stack, 1, 2, false) : burnTime > 0 && !this.func_75135_a(stack, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(p_82846_1_, stack);
        }
        this.func_75142_b();
        return itemstack;
    }

    public ChargingStationTileEntity getTe() {
        return this.te;
    }

    public int getEnergy() {
        return (Integer)this.te.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse((Object)0);
    }
}

