/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.common.capability.CapabilityProviderEnergy;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ChargingStationTileEntity;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class ChargingStationItem
extends BlockItem {
    public ChargingStationItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public ChargingStationItem(Item.Properties builder) {
        this(OurBlocks.chargingStation, builder);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> tooltip.add((ITextComponent)TooltipTranslation.CHARGER_ENERGY.componentTranslation(energy.getEnergyStored())));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapabilityProviderEnergy(stack, () -> ((ForgeConfigSpec.IntValue)Config.CHARGING_STATION.capacity).get());
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        return super.func_195942_a(context);
    }

    @Nullable
    public BlockItemUseContext func_219984_b(BlockItemUseContext context) {
        return super.func_219984_b(context);
    }

    protected boolean func_195943_a(BlockPos pos, World worldIn, @Nullable PlayerEntity player, ItemStack stack, BlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ChargingStationTileEntity) {
            ChargingStationTileEntity station = (ChargingStationTileEntity)te;
            station.onInitEnergy(stack);
        }
        return super.func_195943_a(pos, worldIn, player, stack, state);
    }
}

