/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingMode;
import com.direwolf20.buildinggadgets.common.building.modes.IAtopPlacingGadget;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.ModeGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BuildingRender;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.save.Undo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.FakeBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class GadgetBuilding
extends ModeGadget
implements IAtopPlacingGadget {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public GadgetBuilding(Item.Properties builder, IntSupplier undoLengthSupplier, String undoName) {
        super(builder, undoLengthSupplier, undoName, Reference.BlockReference.TagReference.WHITELIST_BUILDING, Reference.BlockReference.TagReference.BLACKLIST_BUILDING);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_BUILDING.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_BUILDING.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return () -> new BuildingRender(false);
    }

    @Override
    public boolean placeAtop(ItemStack stack) {
        return GadgetBuilding.shouldPlaceAtop(stack);
    }

    private static void setToolMode(ItemStack tool, BuildingMode mode) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        tagCompound.func_74778_a("mode", mode.getRegistryName());
    }

    public static BuildingMode getToolMode(ItemStack tool) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        return BuildingMode.byName(tagCompound.func_74779_i("mode"));
    }

    public static boolean shouldPlaceAtop(ItemStack stack) {
        return !NBTHelper.getOrNewTag(stack).func_74767_n("start_inside");
    }

    public static void togglePlaceAtop(PlayerEntity player, ItemStack stack) {
        NBTHelper.getOrNewTag(stack).func_74757_a("start_inside", GadgetBuilding.shouldPlaceAtop(stack));
        player.func_146105_b((GadgetBuilding.shouldPlaceAtop(stack) ? MessageTranslation.PLACE_ATOP : MessageTranslation.PLACE_INSIDE).componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        BuildingMode mode = GadgetBuilding.getToolMode(stack);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(mode == BuildingMode.SURFACE && GadgetBuilding.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(new Object[]{mode}) : mode).func_150255_a(Styles.AQUA));
        tooltip.add(TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).func_150255_a(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        if (GadgetBuilding.getToolMode(stack) != BuildingMode.TARGETED_AXIS_CHASING) {
            tooltip.add(TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetBuilding.getRangeInBlocks(range, mode.getModeImplementation())).func_150255_a(Styles.LT_PURPLE));
        }
        if (GadgetBuilding.getToolMode(stack) == BuildingMode.SURFACE) {
            tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetBuilding.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        }
        GadgetBuilding.addInformationRayTraceFluid(tooltip, stack);
        tooltip.add(TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetBuilding.shouldPlaceAtop(stack))).func_150255_a(Styles.YELLOW));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else if (player instanceof ServerPlayerEntity) {
                this.build((ServerPlayerEntity)player, itemstack);
            }
        } else if (!player.func_70093_af()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.hasControlDown()) {
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        BuildingMode mode = BuildingMode.values()[modeInt];
        GadgetBuilding.setToolMode(heldItem, mode);
    }

    public static void rangeChange(PlayerEntity player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetBuilding.getToolMode(heldItem) != BuildingMode.SURFACE || range % 2 == 0 ? 1 : 2;
        range = player.func_70093_af() ? (range == 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b(MessageTranslation.RANGE_SET.componentTranslation(range).func_150255_a(Styles.AQUA), true);
    }

    private boolean build(ServerPlayerEntity player, ItemStack stack) {
        World world = player.field_70170_p;
        List<BlockPos> coords = GadgetUtils.getAnchor(stack);
        if (coords.size() == 0) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, stack);
            if (lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt((PlayerEntity)player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_216350_a();
            Direction sideHit = lookingAt.func_216354_b();
            coords = BuildingMode.collectPlacementPos((IWorld)world, (PlayerEntity)player, startBlock, sideHit, stack, startBlock);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        ItemStack heldItem = GadgetBuilding.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        Undo.Builder builder = Undo.builder();
        IItemIndex index = InventoryHelper.index(stack, (PlayerEntity)player);
        if (blockData.getState() != Blocks.field_150350_a.func_176223_P()) {
            fakeWorld.setWorldAndState(player.field_70170_p, blockData.getState(), coords);
            for (BlockPos coordinate : coords) {
                this.placeBlock(world, player, index, builder, coordinate, blockData);
            }
        }
        this.pushUndo(stack, builder.build(world.func_201675_m().func_186058_p()));
        return true;
    }

    private boolean placeBlock(World world, ServerPlayerEntity player, IItemIndex index, Undo.Builder builder, BlockPos pos, BlockData setBlock) {
        if (pos.func_177956_o() > world.getMaxHeight() || pos.func_177956_o() < 0) {
            return false;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        ItemStack heldItem = GadgetBuilding.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        boolean useConstructionPaste = false;
        SimpleBuildContext buildContext = SimpleBuildContext.builder().usedStack(heldItem).buildingPlayer((PlayerEntity)player).build((IWorld)world);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        MatchResult match = index.tryMatch(requiredItems);
        if (!match.isSuccess()) {
            if (setBlock.getState().hasTileEntity()) {
                return false;
            }
            match = index.tryMatch(InventoryHelper.PASTE_LIST);
            if (!match.isSuccess()) {
                return false;
            }
            useConstructionPaste = true;
        }
        if (!world.func_175660_a((PlayerEntity)player, pos)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
            return false;
        }
        if (!this.canUse(heldItem, (PlayerEntity)player)) {
            return false;
        }
        this.applyDamage(heldItem, player);
        if (index.applyMatch(match)) {
            ImmutableMultiset<IUniqueObject<?>> usedItems = match.getChosenOption();
            builder.record((IBlockReader)world, pos, setBlock, (Multiset<IUniqueObject<?>>)usedItems, (Multiset<IUniqueObject<?>>)ImmutableMultiset.of());
            EffectBlock.spawnEffectBlock((IWorld)world, pos, setBlock, EffectBlock.Mode.PLACE, useConstructionPaste);
            return true;
        }
        return false;
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetBuilding)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

