/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingMode;
import com.direwolf20.buildinggadgets.common.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.ModeGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BuildingRender;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.FakeBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class GadgetExchanger
extends ModeGadget {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public GadgetExchanger(Item.Properties builder, IntSupplier undoLengthSupplier, String undoName) {
        super(builder, undoLengthSupplier, undoName, Reference.BlockReference.TagReference.WHITELIST_EXCHANGING, Reference.BlockReference.TagReference.BLACKLIST_EXCHANGING);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return () -> new BuildingRender(true);
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185306_r) || super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185306_r || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private static void setToolMode(ItemStack tool, ExchangingMode mode) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        tagCompound.func_74778_a("mode", mode.getRegistryName());
    }

    public static ExchangingMode getToolMode(ItemStack tool) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        return ExchangingMode.byName(tagCompound.func_74779_i("mode"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        ExchangingMode mode = GadgetExchanger.getToolMode(stack);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(mode == ExchangingMode.SURFACE && GadgetExchanger.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(new Object[]{mode}) : mode).func_150255_a(Styles.AQUA));
        tooltip.add(TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).func_150255_a(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        tooltip.add(TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetExchanger.getRangeInBlocks(range, mode.getModeImplementation())).func_150255_a(Styles.LT_PURPLE));
        tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetExchanger.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        GadgetExchanger.addInformationRayTraceFluid(tooltip, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else if (player instanceof ServerPlayerEntity) {
                this.exchange((ServerPlayerEntity)player, itemstack);
            }
        } else if (!player.func_70093_af()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.hasControlDown()) {
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ExchangingMode mode = ExchangingMode.values()[modeInt];
        GadgetExchanger.setToolMode(heldItem, mode);
    }

    public static void rangeChange(PlayerEntity player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetExchanger.getToolMode(heldItem) == ExchangingMode.GRID || range % 2 == 0 ? 1 : 2;
        range = player.func_70093_af() ? (range <= 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b(MessageTranslation.RANGE_SET.componentTranslation(range).func_150255_a(Styles.AQUA), true);
    }

    private void exchange(ServerPlayerEntity player, ItemStack stack) {
        ServerWorld world = player.func_71121_q();
        ItemStack heldItem = GadgetExchanger.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return;
        }
        List<BlockPos> coords = GadgetUtils.getAnchor(stack);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, stack);
        BlockData blockState = GadgetUtils.getToolBlock(heldItem);
        TileEntity tileEntity = world.func_175625_s(lookingAt.func_216350_a());
        Block lookAtBlock = player.field_70170_p.func_180495_p(lookingAt.func_216350_a()).func_177230_c();
        if (blockState.getState() == Blocks.field_150350_a.func_176223_P() || lookAtBlock == OurBlocks.effectBlock || blockState.getState().func_177230_c() == lookAtBlock || tileEntity != null) {
            return;
        }
        if (coords.size() == 0) {
            BlockPos startBlock = lookingAt.func_216350_a();
            Direction sideHit = lookingAt.func_216354_b();
            coords = ExchangingMode.collectPlacementPos((IWorld)world, (PlayerEntity)player, startBlock, sideHit, stack, startBlock);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>(coords);
        IItemIndex index = InventoryHelper.index(stack, (PlayerEntity)player);
        if (blockState.getState() != Blocks.field_150350_a.func_176223_P()) {
            fakeWorld.setWorldAndState(player.field_70170_p, blockState.getState(), coordinates);
            for (BlockPos coordinate : coords) {
                this.exchangeBlock(world, player, index, coordinate, blockState);
            }
        }
    }

    private void exchangeBlock(ServerWorld world, ServerPlayerEntity player, IItemIndex index, BlockPos pos, BlockData setBlock) {
        ITileEntityData data;
        BlockState currentBlock = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ConstructionBlockTileEntity) {
            data = ((ConstructionBlockTileEntity)te).getConstructionBlockData().getTileData();
            currentBlock = ((ConstructionBlockTileEntity)te).getConstructionBlockData().getState();
        } else {
            data = TileSupport.createTileData((IBlockReader)world, pos);
        }
        ItemStack tool = GadgetExchanger.getGadget((PlayerEntity)player);
        if (tool.func_190926_b()) {
            return;
        }
        SimpleBuildContext buildContext = SimpleBuildContext.builder().usedStack(tool).buildingPlayer((PlayerEntity)player).build((IWorld)world);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        MatchResult match = index.tryMatch(requiredItems);
        boolean useConstructionPaste = false;
        if (!match.isSuccess()) {
            if (setBlock.getState().hasTileEntity()) {
                return;
            }
            match = index.tryMatch(InventoryHelper.PASTE_LIST);
            if (!match.isSuccess()) {
                return;
            }
            useConstructionPaste = true;
        }
        if (!player.func_175142_cm()) {
            return;
        }
        if (!world.func_175660_a((PlayerEntity)player, pos)) {
            return;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
            return;
        }
        BlockEvent.BreakEvent e = new BlockEvent.BreakEvent((World)world, pos, currentBlock, (PlayerEntity)player);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return;
        }
        if (!this.canUse(tool, (PlayerEntity)player)) {
            return;
        }
        this.applyDamage(tool, player);
        if (index.applyMatch(match)) {
            MaterialList materials = te instanceof ConstructionBlockTileEntity ? InventoryHelper.PASTE_LIST : data.getRequiredItems(buildContext, currentBlock, (RayTraceResult)world.func_217299_a(new RayTraceContext(player.func_213303_ch(), new Vec3d((Vec3i)pos), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player)), pos);
            PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> it = materials.iterator();
            LinkedHashMultiset producedItems = LinkedHashMultiset.create();
            if (buildContext.getUsedStack().func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)buildContext.getUsedStack()) > 0) {
                producedItems = it.hasNext() ? (Multiset)it.next() : ImmutableMultiset.of();
            } else {
                List drops = Block.func_220070_a((BlockState)currentBlock, (ServerWorld)((ServerWorld)buildContext.getWorld()), (BlockPos)pos, (TileEntity)buildContext.getWorld().func_175625_s(pos));
                producedItems.addAll((Collection)drops.stream().map(UniqueItem::ofStack).collect(Collectors.toList()));
            }
            index.insert((Multiset<IUniqueObject<?>>)producedItems);
            EffectBlock.spawnEffectBlock((IWorld)world, pos, setBlock, EffectBlock.Mode.REPLACE, useConstructionPaste);
        }
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetExchanger)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }
}

