/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.client.cache.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.client.renderer.FakeTERWorld;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.tools.CapabilityUtil;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.FakeBuilderWorld;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public abstract class BaseRenderer {
    public static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final FakeTERWorld tileEntityWorld = new FakeTERWorld();
    private static final FakeBuilderWorld builderWorld = new FakeBuilderWorld();
    private static final Set<TileEntity> invalidTileEntities = new HashSet<TileEntity>();
    private static RemoteInventoryCache cacheInventory = new RemoteInventoryCache(false);

    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        this.bindBlocks();
        if (this.isLinkable()) {
            BaseRenderer.renderLinkedInventoryOutline(heldItem, player);
        }
    }

    protected void bindBlocks() {
        BaseRenderer.getMc().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
    }

    private static void renderLinkedInventoryOutline(ItemStack item, PlayerEntity player) {
        ResourceLocation dim = GadgetUtils.getDIMFromNBT(item, "bound_te_pos");
        BlockPos pos = GadgetUtils.getPOSFromNBT(item, "bound_te_pos");
        if (dim == null || pos == null) {
            return;
        }
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)dim);
        if (dimension == null || player.field_71093_bK != dimension) {
            return;
        }
        Vec3d renderPos = BaseRenderer.getPlayerPos().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c((double)0.005f, (double)0.005f, (double)-0.005f);
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)32771, (int)32772);
        GlStateManager.translated((double)(-renderPos.func_82615_a()), (double)(-renderPos.func_82617_b()), (double)(-renderPos.func_82616_c()));
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)1.01f, (float)1.01f, (float)1.01f);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        BaseRenderer.getMc().func_175602_ab().func_175016_a(Blocks.field_196811_gn.func_176223_P(), 1.0f);
        GlStateManager.popMatrix();
    }

    int getEnergy(PlayerEntity player, ItemStack heldItem) {
        LazyOptional<IEnergyStorage> energy = CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)heldItem);
        if (player.func_184812_l_() || !energy.isPresent()) {
            return Integer.MAX_VALUE;
        }
        return (Integer)energy.map(IEnergyStorage::getEnergyStored).orElse((Object)0);
    }

    protected BufferBuilder setupMissingRender() {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.alphaFunc((int)516, (float)1.0E-4f);
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)32771, (int)32772);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        return bufferBuilder;
    }

    protected void teardownMissingRender() {
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.blendFunc((int)770, (int)771);
    }

    protected void renderBlock(BlockRendererDispatcher dispatcher, BufferBuilder builder, BlockState state, BlockPos pos, World world, Random random) {
        try {
            dispatcher.renderBlock(state, pos, (IEnviromentBlockReader)world, builder, random, (IModelData)EmptyModelData.INSTANCE);
        }
        catch (Throwable t) {
            BuildingGadgets.LOG.trace("Block at {} with state {} threw exception, whilst rendering", (Object)pos, (Object)state, (Object)t);
        }
    }

    protected void renderBlockTile(BlockRendererDispatcher dispatcher, BlockState state) {
        try {
            dispatcher.func_175016_a(state, 1.0f);
        }
        catch (Throwable t) {
            BuildingGadgets.LOG.trace("Block Tile with state {} threw exception, whilst rendering", (Object)state, (Object)t);
        }
    }

    protected void renderBlockOverlay(BufferBuilder builder, BlockPos pos, float red, float green, float blue, float alpha) {
        double x = (double)pos.func_177958_n() - 0.01;
        double y = (double)pos.func_177956_o() - 0.01;
        double z = (double)pos.func_177952_p() - 0.01;
        double xEnd = (double)pos.func_177958_n() + 1.01;
        double yEnd = (double)pos.func_177956_o() + 1.01;
        double zEnd = (double)pos.func_177952_p() + 1.01;
        this.renderBoxSolid(builder, x, y, z, xEnd, yEnd, zEnd, red, green, blue, alpha);
    }

    protected void renderMissingBlock(BufferBuilder bufferBuilder, BlockPos pos) {
        float red = 0.69f;
        float green = 0.18f;
        float blue = 0.14f;
        float alpha = 0.55f;
        this.renderBlockOverlay(bufferBuilder, pos, red, green, blue, alpha);
    }

    protected void renderBoxSolid(BufferBuilder bufferBuilder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        bufferBuilder.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, yEnd, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, yEnd, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, y, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, yEnd, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, yEnd, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, y, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, y, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, yEnd, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, yEnd, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, yEnd, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, yEnd, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, yEnd, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, y, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, yEnd, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, yEnd, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, yEnd, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(x, y, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(xEnd, y, zEnd).func_181666_a(red, green, blue, alpha).func_181675_d();
    }

    public boolean isLinkable() {
        return false;
    }

    static Minecraft getMc() {
        return Minecraft.func_71410_x();
    }

    static FakeTERWorld getTileEntityWorld() {
        return tileEntityWorld;
    }

    static FakeBuilderWorld getBuilderWorld() {
        return builderWorld;
    }

    static RemoteInventoryCache getCacheInventory() {
        return cacheInventory;
    }

    public static void setInventoryCache(Multiset<UniqueItem> cache) {
        cacheInventory.setCache(cache);
    }

    public static void updateInventoryCache() {
        cacheInventory.forceUpdate();
    }

    static Set<TileEntity> getInvalidTileEntities() {
        return invalidTileEntities;
    }

    static Vec3d getPlayerPos() {
        return new Vec3d(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d);
    }
}

