/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingMode;
import com.direwolf20.buildinggadgets.common.building.modes.ExchangingMode;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.RecordingItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.SortingHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.tools.CapabilityUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public class BuildingRender
extends BaseRenderer {
    private boolean isExchanger;

    public BuildingRender(boolean isExchanger) {
        this.isExchanger = isExchanger;
    }

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        Vec3d playerPos = BaseRenderer.getPlayerPos();
        BlockState state = BaseRenderer.AIR;
        List<BlockPos> coordinates = GadgetUtils.getAnchor(heldItem);
        if (lookingAt != null && player.field_70170_p.func_180495_p(VectorHelper.getLookingAt(player, heldItem).func_216350_a()) != BaseRenderer.AIR || coordinates.size() > 0) {
            World world = player.field_70170_p;
            BlockState startBlock = BaseRenderer.AIR;
            if (lookingAt != null) {
                startBlock = world.func_180495_p(lookingAt.func_216350_a());
            }
            if (startBlock != OurBlocks.effectBlock.func_176223_P()) {
                List<BlockPos> renderCoordinates;
                BlockData data = GadgetUtils.getToolBlock(heldItem);
                BlockState renderBlockState = data.getState();
                if (renderBlockState == BaseRenderer.AIR) {
                    return;
                }
                if (coordinates.size() == 0) {
                    coordinates = this.isExchanger ? ExchangingMode.collectPlacementPos((IWorld)world, player, lookingAt.func_216350_a(), lookingAt.func_216354_b(), heldItem, lookingAt.func_216350_a()) : BuildingMode.collectPlacementPos((IWorld)world, player, lookingAt.func_216350_a(), lookingAt.func_216354_b(), heldItem, lookingAt.func_216350_a());
                    renderCoordinates = coordinates;
                } else {
                    renderCoordinates = SortingHelper.Blocks.byDistance(coordinates, player);
                }
                SimpleBuildContext buildContext = SimpleBuildContext.builder().usedStack(heldItem).buildingPlayer(player).build((IWorld)world);
                RecordingItemIndex index = new RecordingItemIndex(InventoryHelper.index(heldItem, player));
                MaterialList materials = data.getRequiredItems(buildContext, null, null);
                int hasEnergy = this.getEnergy(player, heldItem);
                LazyOptional<IEnergyStorage> energyCap = CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)heldItem);
                BuildingRender.getBuilderWorld().setWorldAndState(player.field_70170_p, renderBlockState, coordinates);
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
                GlStateManager.pushTextureAttributes();
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((int)32771, (int)32772);
                state = renderBlockState;
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                for (BlockPos coordinate : renderCoordinates) {
                    GlStateManager.pushMatrix();
                    GlStateManager.translatef((float)((float)coordinate.func_177958_n() - 0.001f), (float)((float)coordinate.func_177956_o() - 0.001f), (float)((float)coordinate.func_177952_p() - 0.001f));
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (this.isExchanger) {
                        GlStateManager.scalef((float)1.002f, (float)1.002f, (float)1.002f);
                    }
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                    try {
                        blockrendererdispatcher.func_175016_a(state, 1.0f);
                    }
                    catch (Throwable t) {
                        BuildingGadgets.LOG.trace("Block at {} with state {} threw exception, whilst rendering", (Object)coordinate, (Object)state, (Object)t);
                    }
                    GlStateManager.popMatrix();
                }
                BufferBuilder bufferBuilder = this.setupMissingRender();
                for (BlockPos coordinate : coordinates) {
                    MatchResult match;
                    if (energyCap.isPresent()) {
                        hasEnergy -= ((AbstractGadget)heldItem.func_77973_b()).getEnergyCost(heldItem);
                    }
                    if (!(match = index.tryMatch(materials)).isSuccess()) {
                        match = index.tryMatch(InventoryHelper.PASTE_LIST);
                    }
                    if (!match.isSuccess() || hasEnergy < 0) {
                        this.renderMissingBlock(bufferBuilder, coordinate);
                        continue;
                    }
                    index.applyMatch(match);
                    this.renderBlockOverlay(bufferBuilder, coordinate, 0.97f, 1.0f, 0.99f, 0.1f);
                }
                this.teardownMissingRender();
                GlStateManager.blendFunc((int)770, (int)771);
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
                GlStateManager.disableBlend();
                GlStateManager.popAttributes();
                GlStateManager.popMatrix();
            }
        }
    }

    @Override
    public boolean isLinkable() {
        return true;
    }
}

