/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.InvertedPlacementEvaluator;
import com.direwolf20.buildinggadgets.common.building.placement.PlacementChecker;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.RecordingItemIndex;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.Template;
import com.direwolf20.buildinggadgets.common.util.helpers.SortingHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.tools.SimulateEnergyStorage;
import com.direwolf20.buildinggadgets.common.world.FakeDelegationWorld;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public class CopyPasteRender
extends BaseRenderer {
    private ChestRenderer chestRenderer;
    private final Cache<RenderKey, RenderInfo> renderCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).removalListener(notification -> RenderInfo.access$300((RenderInfo)notification.getValue())).build();
    private final Cache<BlockData, Boolean> erroredCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public ChestRenderer getChestRenderer() {
        if (this.chestRenderer == null) {
            this.chestRenderer = new ChestRenderer();
        }
        return this.chestRenderer;
    }

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        if (heldItem.func_190926_b()) {
            return;
        }
        super.render(evt, player, heldItem);
        Vec3d playerPos = CopyPasteRender.getPlayerPos();
        if (GadgetCopyPaste.getToolMode(heldItem) == GadgetCopyPaste.ToolMode.COPY) {
            GadgetCopyPaste.getSelectedRegion(heldItem).ifPresent(region -> this.renderCopy(playerPos, (Region)region));
        } else {
            this.renderPaste(evt, player, heldItem, playerPos);
        }
    }

    private void renderCopy(Vec3d playerPos, Region region) {
        BlockPos startPos = region.getMin();
        BlockPos endPos = region.getMax();
        BlockPos blankPos = new BlockPos(0, 0, 0);
        if (startPos.equals((Object)blankPos) || endPos.equals((Object)blankPos)) {
            return;
        }
        int x = Math.min(startPos.func_177958_n(), endPos.func_177958_n());
        int y = Math.min(startPos.func_177956_o(), endPos.func_177956_o());
        int z = Math.min(startPos.func_177952_p(), endPos.func_177952_p());
        int dx = startPos.func_177958_n() > endPos.func_177958_n() ? startPos.func_177958_n() + 1 : endPos.func_177958_n() + 1;
        int dy = startPos.func_177956_o() > endPos.func_177956_o() ? startPos.func_177956_o() + 1 : endPos.func_177956_o() + 1;
        int dz = startPos.func_177952_p() > endPos.func_177952_p() ? startPos.func_177952_p() + 1 : endPos.func_177952_p() + 1;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
        GlStateManager.disableLighting();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        CopyPasteRender.renderCopyOutline(tessellator, bufferbuilder, x, y, z, dx, dy, dz, 255, 223, 127);
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
        GlStateManager.enableDepthTest();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
    }

    private void renderPaste(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem, Vec3d playerPos) {
        World world = player.field_70170_p;
        world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> heldItem.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
            UUID id = provider.getId((ITemplateKey)key);
            float partialTicks = evt.getPartialTicks();
            GadgetCopyPaste.getActivePos(player, heldItem).ifPresent(startPos -> {
                try {
                    RenderInfo info = (RenderInfo)this.renderCache.get((Object)new RenderKey(id, (BlockPos)startPos), () -> {
                        int displayList = GLAllocation.func_74526_a((int)1);
                        GlStateManager.newList((int)displayList, (int)4864);
                        this.performRender(world, player, heldItem, (BlockPos)startPos, provider.getTemplateForKey((ITemplateKey)key), partialTicks);
                        GlStateManager.endList();
                        return new RenderInfo(displayList);
                    });
                    info.render(playerPos);
                }
                catch (ExecutionException e) {
                    BuildingGadgets.LOG.error("Failed to create Render!", (Throwable)e);
                }
            });
        }));
    }

    private void performRender(World world, PlayerEntity player, ItemStack stack, BlockPos startPos, Template template, float partialTicks) {
        FakeDelegationWorld fakeWorld = new FakeDelegationWorld((IWorld)world);
        SimpleBuildContext context = SimpleBuildContext.builder().buildingPlayer(player).usedStack(stack).build(fakeWorld);
        IBuildView view = template.createViewInContext(context);
        view.translateTo(startPos);
        SortingHelper.RenderSorter sorter = new SortingHelper.RenderSorter(player, view.estimateSize());
        for (PlacementTarget target : view) {
            if (!target.placeIn(context)) continue;
            sorter.onPlaced(target);
        }
        this.renderTargets(context, sorter, partialTicks);
        if (!player.func_184812_l_()) {
            this.renderMissing(player, stack, view, sorter);
        }
        GlStateManager.disableBlend();
    }

    private void renderTargets(IBuildContext context, SortingHelper.RenderSorter sorter, float partialTicks) {
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)32771, (int)32772);
        BlockRendererDispatcher dispatcher = CopyPasteRender.getMc().func_175602_ab();
        TileEntityRendererDispatcher teDispatcher = TileEntityRendererDispatcher.field_147556_a;
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Random rand = new Random();
        for (PlacementTarget target : sorter.getSortedTargets()) {
            BlockPos targetPos = target.getPos();
            BlockState state = context.getWorld().func_180495_p(target.getPos());
            TileEntity te = context.getWorld().func_175625_s(target.getPos());
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)targetPos.func_177958_n(), (float)targetPos.func_177956_o(), (float)targetPos.func_177952_p());
            GlStateManager.enableBlend();
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            try {
                if (state.func_185901_i() == BlockRenderType.MODEL) {
                    dispatcher.renderBlock(state, targetPos, (IEnviromentBlockReader)context.getWorld(), builder, rand, (IModelData)(te != null ? te.getModelData() : EmptyModelData.INSTANCE));
                }
            }
            catch (Exception e) {
                BuildingGadgets.LOG.trace("Caught exception whilst rendering {}.", (Object)state, (Object)e);
            }
            try {
                TileEntityRenderer renderer;
                if (te != null && !((Boolean)this.erroredCache.get((Object)target.getData(), () -> false)).booleanValue() && (renderer = teDispatcher.func_147547_b(te)) != null) {
                    if (te.hasFastRenderer()) {
                        renderer.renderTileEntityFast(te, 0.0, 0.0, 0.0, partialTicks, -1, builder);
                    } else {
                        renderer.func_199341_a(te, 0.0, 0.0, 0.0, partialTicks, -1);
                        this.bindBlocks();
                    }
                }
            }
            catch (Exception e) {
                this.erroredCache.put((Object)target.getData(), (Object)true);
            }
            GlStateManager.popMatrix();
        }
        Tessellator.func_178181_a().func_78381_a();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderMissing(PlayerEntity player, ItemStack stack, IBuildView view, SortingHelper.RenderSorter sorter) {
        int energyCost = ((GadgetCopyPaste)stack.func_77973_b()).getEnergyCost(stack);
        RecordingItemIndex index = new RecordingItemIndex(InventoryHelper.index(stack, player));
        boolean overwrite = (Boolean)Config.GENERAL.allowOverwriteBlocks.get();
        BlockItemUseContext useContext = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, VectorHelper.getLookingAt(player, stack)));
        InvertedPlacementEvaluator evaluator = new InvertedPlacementEvaluator(sorter.getOrderedTargets(), new PlacementChecker((LazyOptional<IEnergyStorage>)stack.getCapability(CapabilityEnergy.ENERGY).map(SimulateEnergyStorage::new), t -> energyCost, index, (c, t) -> overwrite ? player.field_70170_p.func_180495_p(t.getPos()).func_196953_a(useContext) : player.field_70170_p.func_175623_d(t.getPos()), false), view.getContext());
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.enableBlend();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        GlStateManager.alphaFunc((int)516, (float)1.0E-4f);
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (PlacementTarget target : evaluator) {
            this.renderMissingBlock(bufferBuilder, target.getPos());
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    private static boolean isVanillaISTER(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof BedBlock) {
            return true;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof AbstractSkullBlock) {
            return true;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() == Blocks.field_205165_jY) {
            return true;
        }
        if (item == Blocks.field_150477_bB.func_199767_j()) {
            return true;
        }
        if (item == Blocks.field_150447_bR.func_199767_j()) {
            return true;
        }
        if (Block.func_149634_a((Item)item) instanceof ShulkerBoxBlock) {
            return true;
        }
        return Block.func_149634_a((Item)item) instanceof ChestBlock;
    }

    private static void renderCopyOutline(Tessellator tessellator, BufferBuilder bufferBuilder, double startX, double startY, double startZ, double endX, double endY, double endZ, int R, int G, int B) {
        GlStateManager.lineWidth((float)2.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, B, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(B, B, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(B, G, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.lineWidth((float)1.0f);
    }

    private static final class RenderInfo {
        private final int callList;

        private RenderInfo(int callList) {
            this.callList = callList;
        }

        private void render(Vec3d playerPos) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
            GlStateManager.callList((int)this.callList);
            GlStateManager.popMatrix();
        }

        private void onRemove() {
            GLAllocation.func_74523_b((int)this.callList);
        }
    }

    private static final class RenderKey {
        @Nonnull
        private final UUID id;
        @Nonnull
        private final BlockPos targetPos;
        private int hash;

        private RenderKey(UUID id, BlockPos targetPos) {
            this.id = Objects.requireNonNull(id, "Cannot create RenderKey without ID!");
            this.targetPos = Objects.requireNonNull(targetPos, "Cannot create RenderKey for " + id + " without target Pos!");
            this.hash = 0;
        }

        @Nonnull
        private UUID getId() {
            return this.id;
        }

        @Nonnull
        private BlockPos getTargetPos() {
            return this.targetPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RenderKey)) {
                return false;
            }
            RenderKey renderKey = (RenderKey)o;
            if (!this.getId().equals(renderKey.getId())) {
                return false;
            }
            return this.getTargetPos().equals((Object)renderKey.getTargetPos());
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.getId().hashCode();
                this.hash = 31 * this.hash + this.getTargetPos().hashCode();
                return this.hash;
            }
            return this.hash;
        }
    }
}

