/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItemStack;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.opengl.GL14;

public class DestructionRender
extends BaseRenderer {
    private static Cache<Triple<UniqueItemStack, BlockPos, Integer>, Integer> cacheDestructionOverlay = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(1L, TimeUnit.SECONDS).removalListener(removal -> GLAllocation.func_74523_b((int)((Integer)removal.getValue()))).build();

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        Direction facing;
        if (!GadgetDestruction.getOverlay(heldItem)) {
            return;
        }
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        World world = player.field_70170_p;
        BlockPos anchor = ((AbstractGadget)heldItem.func_77973_b()).getAnchor(heldItem);
        if ((lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt(player, heldItem).func_216350_a()) == AIR) && anchor == null) {
            return;
        }
        BlockPos startBlock = anchor == null ? lookingAt.func_216350_a() : anchor;
        Direction direction = facing = GadgetDestruction.getAnchorSide(heldItem) == null ? lookingAt.func_216354_b() : GadgetDestruction.getAnchorSide(heldItem);
        if (world.func_180495_p(startBlock) == OurBlocks.effectBlock.func_176223_P()) {
            return;
        }
        Vec3d playerPos = DestructionRender.getPlayerPos();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
        try {
            GlStateManager.callList((int)((Integer)cacheDestructionOverlay.get((Object)new ImmutableTriple((Object)new UniqueItemStack(heldItem), (Object)startBlock, (Object)facing.ordinal()), () -> {
                int displayList = GLAllocation.func_74526_a((int)1);
                GlStateManager.newList((int)displayList, (int)4864);
                this.renderOverlay(player, world, startBlock, facing, heldItem);
                GlStateManager.endList();
                return displayList;
            })));
        }
        catch (ExecutionException e) {
            BuildingGadgets.LOG.error("Error encountered while rendering destruction gadget overlay", (Throwable)e);
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    private void renderOverlay(PlayerEntity player, World world, BlockPos startBlock, Direction facing, ItemStack heldItem) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = t.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GlStateManager.alphaFunc((int)516, (float)1.0E-4f);
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        for (BlockPos coordinate : GadgetDestruction.getClearingPositionsForRendering(world, startBlock, facing, player, heldItem)) {
            this.renderMissingBlock(bufferBuilder, coordinate);
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.blendFunc((int)770, (int)771);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }
}

