/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRotateMirror {
    private Operation operation;

    public PacketRotateMirror() {
    }

    public PacketRotateMirror(@Nullable Operation operation) {
        this.operation = operation;
    }

    public static void encode(PacketRotateMirror msg, PacketBuffer buffer) {
        boolean hasOperation = msg.operation != null;
        buffer.writeBoolean(hasOperation);
        if (hasOperation) {
            buffer.writeInt(msg.operation.ordinal());
        }
    }

    public static PacketRotateMirror decode(PacketBuffer buffer) {
        return new PacketRotateMirror(buffer.readBoolean() ? Operation.values()[buffer.readInt()] : null);
    }

    public static class Handler {
        public static void handle(PacketRotateMirror msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = AbstractGadget.getGadget((PlayerEntity)player);
                Operation operation = msg.operation != null ? msg.operation : (player.func_70093_af() ? Operation.MIRROR : Operation.ROTATE);
                switch (operation) {
                    case MIRROR: {
                        ((AbstractGadget)stack.func_77973_b()).onMirror(stack, (PlayerEntity)player);
                        break;
                    }
                    default: {
                        ((AbstractGadget)stack.func_77973_b()).onRotate(stack, (PlayerEntity)player);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum Operation {
        ROTATE,
        MIRROR;

    }
}

