/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.direwolf20.buildinggadgets.common.registry.IOrderedRegistry;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

final class ImmutableOrderedRegistry<T>
implements IOrderedRegistry<T> {
    private final ImmutableBiMap<ResourceLocation, T> backingMap;
    private final ImmutableList<T> orderedValues;

    ImmutableOrderedRegistry(Map<ResourceLocation, T> backingMap, List<T> orderedValues) {
        this.backingMap = ImmutableBiMap.copyOf(backingMap);
        this.orderedValues = ImmutableList.copyOf(orderedValues);
    }

    @Override
    @Nullable
    public T get(ResourceLocation key) {
        return (T)this.backingMap.get((Object)key);
    }

    @Override
    public boolean contains(ResourceLocation key) {
        return this.backingMap.containsKey((Object)key);
    }

    @Override
    public ImmutableList<T> getValuesInOrder() {
        return this.orderedValues;
    }

    @Override
    public Stream<T> values() {
        return this.orderedValues.stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.orderedValues.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.orderedValues.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.orderedValues.spliterator();
    }

    @Override
    @Nullable
    public ResourceLocation getKey(T value) {
        return (ResourceLocation)this.backingMap.inverse().get(value);
    }
}

