/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.direwolf20.buildinggadgets.client.renderer.ChargingStationTER;
import com.direwolf20.buildinggadgets.client.renderer.EffectBlockTER;
import com.direwolf20.buildinggadgets.common.blocks.ChargingStationBlock;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockDense;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockPowder;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.TemplateManager;
import com.direwolf20.buildinggadgets.common.items.ChargingStationItem;
import com.direwolf20.buildinggadgets.common.registry.OurItems;
import com.direwolf20.buildinggadgets.common.tiles.ChargingStationTileEntity;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tiles.EffectBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tiles.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class OurBlocks {
    @ObjectHolder(value="buildinggadgets:effect_block")
    public static EffectBlock effectBlock;
    @ObjectHolder(value="buildinggadgets:construction_block")
    public static ConstructionBlock constructionBlock;
    @ObjectHolder(value="buildinggadgets:construction_block_dense")
    public static ConstructionBlockDense constructionBlockDense;
    @ObjectHolder(value="buildinggadgets:construction_block_powder")
    public static ConstructionBlockPowder constructionBlockPowder;
    @ObjectHolder(value="buildinggadgets:template_manager")
    public static TemplateManager templateManger;
    @ObjectHolder(value="buildinggadgets:charging_station")
    public static ChargingStationBlock chargingStation;
    private static final Material EFFECT_BLOCK_MATERIAL;

    private OurBlocks() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new EffectBlock(Block.Properties.func_200945_a((Material)EFFECT_BLOCK_MATERIAL).func_200943_b(20.0f)).setRegistryName(Reference.BlockReference.EFFECT_BLOCK_RL));
        registry.register(new ConstructionBlock(Block.Properties.func_200945_a((Material)Material.field_151595_p).func_200948_a(2.0f, 0.0f).harvestTool(ToolType.SHOVEL)).setRegistryName(Reference.BlockReference.CONSTRUCTION_BLOCK_RL));
        registry.register(new ConstructionBlockDense(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 0.0f)).setRegistryName(Reference.BlockReference.CONSTRUCTION_BLOCK_DENSE_RL));
        registry.register(new ConstructionBlockPowder(Block.Properties.func_200945_a((Material)Material.field_151595_p).func_200943_b(10.0f)).setRegistryName(Reference.BlockReference.CONSTRUCTION_BLOCK_POWDER_RL));
        registry.register(new TemplateManager(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f)).setRegistryName(Reference.BlockReference.TEMPLATE_MANAGER_RL));
        registry.register(new ChargingStationBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f)).setRegistryName(Reference.BlockReference.CHARGING_STATION_RL));
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new BlockItem((Block)constructionBlock, OurItems.itemProperties()).setRegistryName(Reference.BlockReference.CONSTRUCTION_BLOCK_RL));
        registry.register(new BlockItem((Block)constructionBlockDense, OurItems.itemProperties()).setRegistryName(Reference.BlockReference.CONSTRUCTION_BLOCK_DENSE_RL));
        registry.register(new BlockItem((Block)constructionBlockPowder, OurItems.itemProperties()).setRegistryName(Reference.BlockReference.CONSTRUCTION_BLOCK_POWDER_RL));
        registry.register(new BlockItem((Block)templateManger, OurItems.itemProperties()).setRegistryName(Reference.BlockReference.TEMPLATE_MANAGER_RL));
        registry.register(new ChargingStationItem(OurItems.itemProperties()).setRegistryName(Reference.BlockReference.CHARGING_STATION_RL));
    }

    @SubscribeEvent
    public static void registerTiles(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(TileEntityType.Builder.func_223042_a(EffectBlockTileEntity::new, (Block[])new Block[]{effectBlock}).func_206865_a(null).setRegistryName(Reference.TileEntityReference.EFFECT_BLOCK_TILE_RL));
        registry.register(TileEntityType.Builder.func_223042_a(ConstructionBlockTileEntity::new, (Block[])new Block[]{constructionBlock}).func_206865_a(null).setRegistryName(Reference.TileEntityReference.CONSTRUCTION_TILE_RL));
        registry.register(TileEntityType.Builder.func_223042_a(TemplateManagerTileEntity::new, (Block[])new Block[]{templateManger}).func_206865_a(null).setRegistryName(Reference.TileEntityReference.TEMPLATE_MANAGER_TILE_RL));
        registry.register(TileEntityType.Builder.func_223042_a(ChargingStationTileEntity::new, (Block[])new Block[]{chargingStation}).func_206865_a(null).setRegistryName(Reference.TileEntityReference.CHARGING_STATION_TILE_RL));
    }

    static {
        EFFECT_BLOCK_MATERIAL = new Material.Builder(MaterialColor.field_151660_b).func_200502_b().func_200506_i();
    }

    public static final class OurTileEntities {
        @ObjectHolder(value="buildinggadgets:construction_tile")
        public static TileEntityType<?> CONSTRUCTION_BLOCK_TYPE;
        @ObjectHolder(value="buildinggadgets:template_manager_tile")
        public static TileEntityType<?> TEMPLATE_MANAGER_TYPE;
        @ObjectHolder(value="buildinggadgets:charging_station_tile")
        public static TileEntityType<?> CHARGING_STATION_TYPE;
        @ObjectHolder(value="buildinggadgets:effect_block_tile")
        public static TileEntityType<?> EFFECT_BLOCK_TYPE;

        private OurTileEntities() {
        }

        @OnlyIn(value=Dist.CLIENT)
        static void registerRenderers() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
                ClientRegistry.bindTileEntitySpecialRenderer(EffectBlockTileEntity.class, (TileEntityRenderer)new EffectBlockTER());
                ClientRegistry.bindTileEntitySpecialRenderer(ChargingStationTileEntity.class, (TileEntityRenderer)new ChargingStationTER());
            });
        }
    }
}

