/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.save;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class WorldSave
extends WorldSavedData {
    private final String TAG_NAME;
    private Map<String, CompoundNBT> tagMap = new HashMap<String, CompoundNBT>();

    public WorldSave(String name, String tagName) {
        super(name);
        this.TAG_NAME = tagName;
    }

    public void addToMap(String UUID2, CompoundNBT tagCompound) {
        this.tagMap.put(UUID2, tagCompound);
        this.func_76185_a();
    }

    public Map<String, CompoundNBT> getTagMap() {
        return this.tagMap;
    }

    public void setTagMap(Map<String, CompoundNBT> newMap) {
        this.tagMap = new HashMap<String, CompoundNBT>(newMap);
    }

    public CompoundNBT getCompoundFromUUID(String UUID2) {
        CompoundNBT nbt = this.tagMap.get(UUID2);
        return nbt != null ? nbt : new CompoundNBT();
    }

    public void markForSaving() {
        this.func_76185_a();
    }

    public static WorldSave getWorldSave(World world) {
        return WorldSave.get(world, "block_map_data", () -> new WorldSaveBlockMap("block_map_data"));
    }

    public static WorldSave getTemplateWorldSave(World world) {
        return WorldSave.get(world, "template_data", () -> new WorldSaveTemplate("template_data"));
    }

    @Nonnull
    private static <T extends WorldSave> WorldSave get(World world, String name, Supplier<T> supplier) {
        DimensionSavedDataManager storage = ((ServerWorld)world).func_217481_x();
        WorldSave data = (WorldSave)storage.func_215752_a(supplier, name);
        return data;
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b(this.TAG_NAME)) {
            ListNBT tagList = nbt.func_150295_c(this.TAG_NAME, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT mapTag = tagList.func_150305_b(i);
                String ID = mapTag.func_74779_i("uuid");
                CompoundNBT tagCompound = mapTag.func_74775_l("tag");
                this.tagMap.put(ID, tagCompound);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<String, CompoundNBT> entry : this.tagMap.entrySet()) {
            CompoundNBT map = new CompoundNBT();
            map.func_74778_a("uuid", entry.getKey());
            map.func_218657_a("tag", (INBT)entry.getValue());
            tagList.add((Object)map);
        }
        compound.func_218657_a(this.TAG_NAME, (INBT)tagList);
        return compound;
    }

    public static class WorldSaveTemplate
    extends WorldSave {
        public static final String NAME = "template_data";

        public WorldSaveTemplate(String name) {
            super(name, NAME);
        }
    }

    public static class WorldSaveBlockMap
    extends WorldSave {
        public static final String NAME = "block_map_data";

        public WorldSaveBlockMap(String name) {
            super(name, NAME);
        }
    }
}

