/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.template;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateParseException;
import com.direwolf20.buildinggadgets.common.util.tools.JsonBiDiSerializer;
import com.google.common.base.Preconditions;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.apache.maven.artifact.versioning.ComparableVersion;

public final class TemplateHeader {
    public static final String VERSION = "2-beta";
    private static final ComparableVersion COMP_VERSION = new ComparableVersion("2-beta");
    private static final String MC_VERSION = "1.14.4";
    private static final JsonBiDiSerializer<TemplateHeader> BI_DI_SERIALIZER = new JsonBiDiSerializer<TemplateHeader>(){

        public TemplateHeader deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            String mcVersion = object.getAsJsonPrimitive("mc_version").getAsString();
            if (!mcVersion.equals(TemplateHeader.MC_VERSION)) {
                throw new TemplateParseException.IllegalMinecraftVersionException(mcVersion, TemplateHeader.MC_VERSION);
            }
            String version = object.getAsJsonPrimitive("version").getAsString();
            if (new ComparableVersion(version).compareTo(COMP_VERSION) > 0) {
                throw new TemplateParseException.UnknownTemplateVersionException(version);
            }
            Builder builder = object.has("bounding_box") ? TemplateHeader.builder((Region)context.deserialize(object.get("bounding_box"), Region.class)) : TemplateHeader.builder(Region.singleZero());
            if (object.has("name")) {
                builder.name((String)context.deserialize(object.get("name"), String.class));
            }
            if (object.has("author")) {
                builder.author((String)context.deserialize(object.get("author"), String.class));
            }
            if (object.has("material_list")) {
                builder.requiredItems((MaterialList)context.deserialize(object.get("material_list"), MaterialList.class));
            }
            return builder.build();
        }

        public JsonElement serialize(TemplateHeader src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("version", TemplateHeader.VERSION);
            object.addProperty("mc_version", TemplateHeader.MC_VERSION);
            if (src.getName() != null) {
                object.addProperty("name", src.getName());
            }
            if (src.getAuthor() != null) {
                object.addProperty("author", src.getAuthor());
            }
            object.add("bounding_box", context.serialize((Object)src.getBoundingBox(), Region.class));
            if (src.getRequiredItems() != null) {
                object.add("material_list", context.serialize((Object)src.getRequiredItems(), MaterialList.class));
            }
            return object;
        }
    };
    @Nullable
    private final String name;
    @Nullable
    private final String author;
    @Nonnull
    private final Region boundingBox;
    @Nullable
    private final MaterialList requiredItems;

    public static Builder builder(Region boundingBox) {
        return new Builder(boundingBox);
    }

    public static Builder builderOf(TemplateHeader header) {
        return TemplateHeader.builderOf(header, header.getBoundingBox());
    }

    public static Builder builderOf(TemplateHeader header, Region boundingBox) {
        return TemplateHeader.builder(boundingBox).author(header.getAuthor()).name(header.getName()).requiredItems(header.getRequiredItems());
    }

    public static Builder builderFromNBT(CompoundNBT nbt, boolean persisted) {
        Preconditions.checkArgument((boolean)nbt.func_150297_b("bounds", 10), (Object)"Cannot construct a TemplateHeader without 'bounds'!");
        Region region = Region.deserializeFrom(nbt.func_74775_l("bounds"));
        Builder builder = TemplateHeader.builder(region);
        if (nbt.func_150297_b("name", 8)) {
            builder.name(nbt.func_74779_i("name"));
        }
        if (nbt.func_150297_b("author", 8)) {
            builder.author(nbt.func_74779_i("author"));
        }
        if (nbt.func_150297_b("materials", 10)) {
            builder.requiredItems(MaterialList.deserialize(nbt.func_74775_l("materials"), persisted));
        }
        return builder;
    }

    public static Builder builderFromNBT(CompoundNBT nbt) {
        return TemplateHeader.builderFromNBT(nbt, true);
    }

    public static TemplateHeader fromNBT(CompoundNBT nbt) {
        return TemplateHeader.builderFromNBT(nbt).build();
    }

    public static GsonBuilder appendHeaderSpecification(GsonBuilder builder, boolean printName, boolean extended) {
        return builder.setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(ResourceLocation.class, (Object)new JsonBiDiSerializer<ResourceLocation>(){

            public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new ResourceLocation(json.getAsJsonPrimitive().getAsString());
            }

            public JsonElement serialize(ResourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        }).registerTypeAdapter(MaterialList.class, (Object)new MaterialList.JsonSerializer(printName, extended)).registerTypeAdapter(TemplateHeader.class, BI_DI_SERIALIZER);
    }

    private TemplateHeader(@Nullable String name, @Nullable String author, @Nullable MaterialList requiredItems, @Nonnull Region boundingBox) {
        this.name = name;
        this.author = author;
        this.requiredItems = requiredItems;
        this.boundingBox = Objects.requireNonNull(boundingBox);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public MaterialList getRequiredItems() {
        return this.requiredItems;
    }

    public Region getBoundingBox() {
        return this.boundingBox;
    }

    public CompoundNBT toNBT(boolean persisted) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("bounds", (INBT)this.getBoundingBox().serialize());
        if (this.getName() != null) {
            nbt.func_74778_a("name", this.getName());
        }
        if (this.getAuthor() != null) {
            nbt.func_74778_a("author", this.getAuthor());
        }
        if (!persisted && this.getRequiredItems() != null) {
            nbt.func_218657_a("materials", (INBT)this.getRequiredItems().serialize(persisted));
        }
        return nbt;
    }

    public String toJson(boolean printName, boolean extended) {
        return TemplateHeader.appendHeaderSpecification(new GsonBuilder(), printName, extended).create().toJson((Object)this);
    }

    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String author;
        @Nullable
        private MaterialList requiredItems;
        @Nonnull
        private Region boundingBox;

        private Builder(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
        }

        public Builder bounds(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        public Builder requiredItems(@Nullable MaterialList requiredItems) {
            this.requiredItems = requiredItems;
            return this;
        }

        public TemplateHeader build() {
            return new TemplateHeader(this.name, this.author, this.requiredItems, this.boundingBox);
        }
    }
}

